/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.ConjunctionPosition;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.DialectFactory;
import com.definesys.mpaas.query.db.PageQueryResult;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.excel.MpaasExcel;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.executor.InsertExecutor;
import com.definesys.mpaas.query.link.LinkHandler;
import com.definesys.mpaas.query.model.BasePojo;
import com.definesys.mpaas.query.model.MpaasBasePojo;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.plugin.Plugin;
import com.definesys.mpaas.query.session.MpaasSession;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.definesys.mpaas.query.util.SQLUtil;
import com.definesys.mpaas.query.util.TypeUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MpaasQuery {
    private String sql;
    private String templateSql;
    private String countSQL;
    private Integer page;
    private Integer pageSize;
    private String table;
    private Object pojo;
    private Class pojoClazz;
    private Boolean upper2Underline;
    private String clauseConjuction = "and";
    private String excelFileName;
    private Integer rowVersion;
    private String viewName;
    private boolean viewQueryMode = false;
    private boolean fullUpdate = true;
    private List<Clause> clauses = new ArrayList<Clause>();
    private List<Parameter> params = new ArrayList<Parameter>();
    private List<Clause> updateField = new ArrayList<Clause>();
    private List<Parameter> orderby = new ArrayList<Parameter>();
    private List<Clause> variables = new ArrayList<Clause>();
    private Set<String> selectFields;
    private Set<String> unSelectFields;
    private Set<String> includeFields;
    private Set<String> excludeFields;
    private String groupby;
    private String distinct;
    private Dialect dialect;
    private DatabaseAdapter dbAdapter;
    private String[] updateFieldNames;
    private String rowid;
    private PojoMeta pojoInfo;
    private List<ConjunctionPosition> groupConIndex = new ArrayList<ConjunctionPosition>();
    private boolean viewConverted = false;
    private MpaasQueryConfig config;
    private SWordLogger logger;
    private int clausePosition = 0;
    private Boolean tenantEnable = false;
    private String tenantId;
    private Boolean softDeleteEnable = true;
    private List<Plugin> plugins;
    private String schema;
    private Boolean ignoreEmptyString = true;

    @Autowired
    public MpaasQuery(DialectFactory dialectFactory, DatabaseAdapterFactory databaseAdapterFactory, MpaasQueryConfig config, SWordLogger logger) {
        Dialect dialect;
        this.dialect = dialect = dialectFactory.buildDatabaseDialect();
        this.dbAdapter = databaseAdapterFactory.buildDatabaseAdapter();
        this.config = config;
        this.logger = logger;
        this.pageSize(this.config.PAGE_SIZE);
    }

    public MpaasQuery clone() {
        return new MpaasQuery(this.dialect, this.dbAdapter, this.config, this.logger, this.plugins);
    }

    public MpaasQuery(Dialect dialect, DatabaseAdapter dbAdapter, MpaasQueryConfig config, SWordLogger logger, List<Plugin> plugins) {
        this.dialect = dialect;
        this.dbAdapter = dbAdapter;
        this.config = config;
        this.logger = logger;
        this.plugins = plugins;
    }

    public MpaasQuery addClause(String name, String op, Object ... value) {
        return this.addClause(false, name, op, value);
    }

    public MpaasQuery addClause(Boolean reverse, String name, String op, Object ... value) {
        value = this.preHandleValue(value);
        if (!("is null".equals(op) || "is not null".equals(op) || "var is null".equals(op) || "var is not null".equals(op))) {
            if (value == null) {
                return this;
            }
            boolean bok = false;
            for (Object ob : value) {
                if (ob == null) continue;
                bok = true;
            }
            if (!bok) {
                ++this.clausePosition;
                return this;
            }
        }
        if ("between".equals(op)) {
            value = value != null && value.length == 0 ? null : value;
            Object begin = value == null ? null : value[0];
            Object end = value == null || value.length == 1 ? null : value[1];
            this.addClause(name, ">=", begin);
            this.addClause(name, "<", end);
        } else {
            this.addClause(new Clause(reverse, name, op, this.clauseConjuction, value));
        }
        return this;
    }

    private Object[] preHandleValue(Object ... value) {
        if (value != null && value.length == 1 && value[0] == null) {
            return null;
        }
        if (value != null && value.length == 1 && value[0] instanceof String) {
            String s = (String)value[0];
            if (this.ignoreEmptyString.booleanValue() && s != null && s.trim().length() == 0) {
                value = null;
            }
        }
        return value;
    }

    public MpaasQuery addRowIdClause(String name, String op, String value) {
        return this.addClause(name, op, this.decryptRowId(value, String.class));
    }

    public MpaasQuery rowid(String field, String rowid) {
        return this.rowid(field, rowid, true);
    }

    public MpaasQuery rowid(String field, String rowid, boolean decrypt) {
        this.rowid = rowid;
        if (decrypt) {
            return this.addClause(field, "=", this.decryptRowId(rowid, String.class));
        }
        return this.addClause(field, "=", rowid);
    }

    public MpaasQuery rowid(String rowid) {
        this.rowid = rowid;
        return this.rowid("id", rowid, false);
    }

    public MpaasQuery sql(String sql) {
        this.sql = sql;
        return this;
    }

    public MpaasQuery table(String table) {
        this.table = table;
        return this;
    }

    public MpaasQuery view(String viewName) {
        this.viewName = viewName;
        return this;
    }

    public MpaasQuery viewQueryMode(boolean enable) {
        this.viewQueryMode = enable;
        return this;
    }

    public MpaasQuery countSql(String sql) {
        this.countSQL = sql;
        return this;
    }

    public MpaasQuery page(Integer page) {
        this.page = page;
        return this;
    }

    public MpaasQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MpaasQuery update(String field, Object value) {
        this.fullUpdate = false;
        String tag = null;
        if (value == null || value instanceof String && ((String)value).length() == 0) {
            tag = field + " = null";
        }
        return this.update(field, value, tag);
    }

    private void update(Clause clause) {
        if (clause.getTag() != null) {
            this.update(clause.getField(), null, clause.getTag());
        } else {
            this.update(clause.getField(), clause.getValue(), null);
        }
    }

    private MpaasQuery update(String field, Object value, Object tag) {
        int index = 0;
        Clause clause = new Clause(field, value);
        clause.setTag(tag);
        for (Clause c : this.updateField) {
            if (c.getField() == null || !c.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        this.updateField.add(clause);
        return this;
    }

    public MpaasQuery update(String[] fields) {
        this.updateFieldNames = fields;
        this.fullUpdate = false;
        return this;
    }

    public MpaasQuery update(List<String> fields) {
        return this.update(fields.toArray(new String[fields.size()]));
    }

    public MpaasQuery version(Integer rowVersion) {
        this.rowVersion = rowVersion;
        return this;
    }

    public MpaasQuery bind(Object pojo) {
        if (pojo instanceof Class) {
            return this.bind((Class)pojo);
        }
        this.pojo = pojo;
        if (this.isBatchInsert()) {
            return this.bind(((Collection)pojo).toArray()[0].getClass());
        }
        return this.bind(this.pojo.getClass());
    }

    public MpaasQuery bind(Class pojoClazz) {
        if (TypeUtil.isBasicType(pojoClazz)) {
            return this;
        }
        this.pojoClazz = pojoClazz;
        PojoMeta pm = this.getPojoMetaInfo();
        if (this.table == null) {
            this.table = pm.getTableName();
        }
        if (this.upper2Underline == null) {
            this.upper2Underline = pm.getUpper2Underline();
        }
        if (this.tenantEnable == null) {
            this.tenantEnable = pm.isTenantEnable();
        }
        return this;
    }

    private PojoMeta getPojoMetaInfo() {
        if (this.pojoClazz == null) {
            return null;
        }
        if (this.pojoInfo != null) {
            return this.pojoInfo;
        }
        this.pojoInfo = this.pojo != null && this.pojo instanceof RowData ? new PojoMeta(this.pojo) : (PojoMeta)PojoCache.cache().get(this.pojoClazz.getName(), this.pojoClazz);
        return this.pojoInfo;
    }

    private void addClause(Clause clause) {
        if (this.clauses == null) {
            this.clauses = new ArrayList<Clause>();
        }
        int index = 0;
        for (Clause c : this.clauses) {
            if (!c.getField().equals(clause.getField())) continue;
            ++index;
        }
        for (Clause c : this.updateField) {
            if (!c.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        clause.setPosition(this.clausePosition++);
        this.clauses.add(clause);
    }

    public <T> List<T> doQuery(Class<T> result) {
        this.bind(result);
        this.preQuery();
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        QueryInfo queryInfo = this.buildQueryInfo();
        List<T> rs = queryInfo.getDbAdapter().executeQuery(queryInfo, query, parameters, result);
        rs = this.postQuery(rs);
        this.clear();
        return this.join(rs, null).getTable();
    }

    public List<Map<String, Object>> doQuery() {
        this.preQuery();
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        QueryInfo queryInfo = this.buildQueryInfo();
        List<Map<String, Object>> rs = queryInfo.getDbAdapter().executeQueryAsList(this.buildQueryInfo(), query, parameters);
        this.clear();
        rs = this.join(rs, null).getTable();
        return rs;
    }

    protected ExecuteResult join(List data, PageQueryResult pageResult) {
        LinkHandler.build().loadLinkData(data == null ? pageResult.getResult() : data);
        ExecuteResult result = new ExecuteResult();
        result.setPageQueryResult(pageResult);
        result.setTable(data);
        return result;
    }

    public <T> T doQueryFirst(Class<T> result) {
        List<T> rs = this.doQuery(result);
        if (rs == null || rs.size() == 0) {
            return null;
        }
        return rs.get(0);
    }

    public Map<String, Object> doQueryFirst() {
        List<Map<String, Object>> rs = this.doQuery();
        if (rs == null || rs.size() == 0) {
            return null;
        }
        return rs.get(0);
    }

    public PageQueryResult doPageQuery() {
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page, Integer pageSize) {
        this.preQuery();
        this.pageSize = pageSize;
        this.page = page;
        if (this.pojoClazz != null) {
            return this.doPageQuery(this.page, this.pageSize, this.pojoClazz);
        }
        String query = this.buildQuerySql(this.page, this.pageSize);
        PageQueryResult<Map<String, Object>> pageQueryResult = new PageQueryResult<Map<String, Object>>();
        QueryInfo queryInfo = this.buildQueryInfo();
        pageQueryResult.setResult(queryInfo.getDbAdapter().executeQueryAsList(queryInfo, query, this.buildParameter()));
        this.params.clear();
        for (ConjunctionPosition p : this.groupConIndex) {
            p.setHit(false);
        }
        String sql = this.buildCountSql();
        QueryInfo q = this.buildQueryInfo();
        q.setTag("count");
        List<Long> count = queryInfo.getDbAdapter().executeQuery(q, sql, this.buildParameter(), Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.clear();
        return this.join(null, pageQueryResult).getPageQueryResult();
    }

    public <T> PageQueryResult<T> doPageQuery(Class<T> result) {
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Class<T> result) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Integer pageSize, Class<T> result) {
        this.bind(result);
        this.preQuery();
        this.pageSize = pageSize;
        this.page = page;
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        PageQueryResult pageQueryResult = new PageQueryResult();
        QueryInfo queryInfo = this.buildQueryInfo();
        pageQueryResult.setResult(this.postQuery(queryInfo.getDbAdapter().executeQuery(queryInfo, query, parameters, result)));
        this.params.clear();
        for (ConjunctionPosition p : this.groupConIndex) {
            p.setHit(false);
        }
        String cntSql = null;
        if (this.isSqlDatabase().booleanValue()) {
            cntSql = this.buildCountSql();
            parameters = this.buildParameter();
        }
        QueryInfo q = this.buildQueryInfo();
        q.setTag("count");
        List<Long> count = queryInfo.getDbAdapter().executeQuery(q, cntSql, parameters, Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.clear();
        pageQueryResult = this.join(null, pageQueryResult).getPageQueryResult();
        return pageQueryResult;
    }

    public Integer doDelete() {
        if (this.softDeleteEnable()) {
            return this.softDelete();
        }
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildDeleteSql();
            parameters = this.buildParameter();
        }
        Integer effectRows = this.dbAdapter.executeDelete(this.buildQueryInfo(), query, parameters);
        this.clear();
        return effectRows;
    }

    public Integer doDelete(Object pojo) {
        this.bind(pojo);
        return this.doDelete();
    }

    public Integer doUpdate(Object pojo) {
        this.bind(pojo);
        return this.doUpdate();
    }

    public Integer doUpdate() {
        boolean valid = false;
        if (this.clauses.size() == 0) {
            if (this.pojo != null) {
                PojoField idField = this.getPojoMetaInfo().getRowIdField();
                if (this.pojo instanceof BasePojo && ((BasePojo)this.pojo).pojoId() != null) {
                    this.rowid(idField.getField().getName(), (String)((BasePojo)this.pojo).pojoId());
                    valid = true;
                }
                Object value = idField.getValue(this.pojo);
                if (!valid && idField != null && value != null) {
                    this.eq(idField.getFieldName(), value);
                    valid = true;
                }
            }
            if (!valid) {
                throw MpaasRuntimeException.fromCode("SW-180227", new Object[0]);
            }
        }
        if (this.pojo != null) {
            PojoMeta pm = this.getPojoMetaInfo();
            List<Clause> cls = pm.updateActionInit(this.pojo, this.getUpdateFieldNames());
            this.updateField.clear();
            for (Clause c : cls) {
                this.update(c);
            }
        }
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildUpdateSql();
            parameters = this.buildParameter();
        }
        int effectRows = this.dbAdapter.executeUpdate(this.buildQueryInfo(), query, parameters);
        this.clear();
        return effectRows;
    }

    public Object doInsert() {
        InsertExecutor builder = new InsertExecutor();
        ExecuteResult result = builder.execute(this.buildQueryInfo());
        return result.getData();
    }

    public Object doInsert(Object pojo) {
        this.bind(pojo);
        return this.doInsert();
    }

    public Object doBatchInsert(Collection pojo) {
        this.bind(pojo);
        return this.doInsert();
    }

    public MpaasQuery doExport(HttpServletResponse response, Class pojo) {
        return this.doExport(response, pojo, this.config.exportPageSize);
    }

    public MpaasQuery doExport(HttpServletResponse response, Class pojo, Integer pageSize) {
        if (this.excelFileName == null) {
            this.excelFileName = "excel.xlsx";
        }
        if (!this.excelFileName.endsWith(".xlsx")) {
            this.excelFileName = this.excelFileName + ".xlsx";
        }
        response.setContentType("application/octet-stream");
        try {
            String f = new String(this.excelFileName.getBytes("UTF-8"), "ISO8859_1");
            response.setHeader("Content-Disposition", "attachment;filename=" + f);
            this.doExport((OutputStream)response.getOutputStream(), pojo, pageSize);
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException(ex);
        }
        return this;
    }

    public MpaasQuery doExport(OutputStream os, Class pojo) {
        return this.doExport(os, pojo, this.config.exportPageSize);
    }

    public MpaasQuery doExport(OutputStream os, Class pojo, Integer pageSize) {
        this.bind(pojo);
        PojoMeta pm = this.getPojoMetaInfo();
        MpaasExcel me = new MpaasExcel(os, pm, this.includeFields, this.excludeFields);
        int currentPage = 1;
        String tmp = this.sql;
        while (true) {
            this.pageSize = pageSize;
            this.page = currentPage;
            String query = this.buildQuerySql(this.page, this.pageSize);
            List<Object> result = this.dbAdapter.executeQuery(this.buildQueryInfo(), query, this.buildParameter(), pojo);
            if (result == null || result.size() == 0) break;
            me.export(result);
            ++currentPage;
            this.sql = tmp;
            this.viewConverted = false;
        }
        me.finish();
        this.clear();
        return this;
    }

    private String buildQuerySql(Integer page, Integer pageSize) {
        this.sql = this.buildSelectSql();
        String s = this.sql + " " + this.buildWhereClause();
        if (page != null && pageSize != null) {
            s = this.dialect.buildPageQuery(s, page, pageSize);
        }
        if (this.templateSql != null) {
            s = this.templateSql.replaceAll("\\$sql", Matcher.quoteReplacement("(" + s + ")"));
        }
        return s;
    }

    public MpaasQuery orderBy(String field, String type) {
        this.orderby.add(new Parameter(field, type));
        return this;
    }

    public MpaasQuery groupBy(String field) {
        this.groupby = field;
        return this;
    }

    private String buildCountSql() {
        String s;
        if (this.countSQL == null) {
            this.sql = this.buildSelectSql();
            s = this.sql + " " + this.buildWhereClause(false);
        } else {
            s = this.countSQL + " " + this.buildWhereClause(false);
        }
        s = String.format("select count(1)l from(%s)y", s);
        return s;
    }

    private String buildDeleteSql() {
        if (MpaasUtil.strEmpty(this.getTableName())) {
            throw MpaasRuntimeException.fromCode("SW-180226", new Object[0]);
        }
        return String.format("delete from %s %s", this.getTableName(), this.buildWhereClause());
    }

    private String buildUpdateSql() {
        if (MpaasUtil.strEmpty(this.getTableName())) {
            throw MpaasRuntimeException.fromCode("SW-180226", new Object[0]);
        }
        return String.format("update %s %s %s", this.getTableName(), this.buildUpdateSetClause(), this.buildWhereClause());
    }

    private void clear() {
        this.params.clear();
        this.updateField.clear();
        this.orderby.clear();
        this.clauses.clear();
        this.upper2Underline = null;
        this.clauseConjuction = "and";
        this.groupConIndex.clear();
        this.variables.clear();
        if (this.includeFields != null) {
            this.includeFields.clear();
        }
        if (this.excludeFields != null) {
            this.excludeFields.clear();
        }
        if (this.selectFields != null) {
            this.selectFields.clear();
        }
        this.updateFieldNames = null;
        this.viewQueryMode = false;
        this.viewName = null;
        this.viewConverted = false;
        this.clausePosition = 0;
        this.page = null;
        this.fullUpdate = true;
        this.pojoInfo = null;
        this.pojoClazz = null;
        this.sql = null;
        this.countSQL = null;
    }

    private String buildUpdateSetClause() {
        StringBuffer sb = new StringBuffer();
        String varFormat = this.getVariableFormat();
        for (Clause c : this.updateField) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                sb.append("set ");
            }
            if (c.getTag() == null) {
                this.params.add(new Parameter(c.getVariable(), c.getValue()));
                sb.append(String.format("%s=" + varFormat, c.getField(), c.getVariable()));
                continue;
            }
            sb.append(c.getTag().toString());
        }
        return sb.toString();
    }

    private String buildWhereClause() {
        return this.buildWhereClause(true);
    }

    private String buildWhereClause(boolean appendOrder) {
        StringBuffer sb = new StringBuffer();
        PojoMeta pm = this.getPojoMetaInfo();
        for (int i = 0; i < this.clauses.size(); ++i) {
            Clause c = this.clauses.get(i);
            if (pm != null) {
                c.setField(pm.getFieldDBName(c.getField()));
            } else {
                c.setField(c.getField());
            }
            c.setVariableFormat(this.getVariableFormat());
            ClauseSQL cs = this.dialect.handleClause(c);
            if (ClauseSQL.NONE.equals(cs.getType())) continue;
            if (ClauseSQL.VARIABLE.equals(cs.getType())) {
                this.params.add(new Parameter(c.getVariable(), c.getValue()));
            }
            String sql = cs.getSqlClause();
            if (sb.length() == 0) {
                sb.append("where (");
            }
            sb.append(this.calculateConjunction(c.getPosition()));
            if (i > 0) {
                sb.append(" " + c.getConjunction() + " ");
            }
            sb.append(sql);
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        sb = new StringBuffer(this.buildWhereClausePost(sb.toString()));
        if (this.groupby != null) {
            sb.append(" group by " + this.groupby + " ");
        }
        boolean flag = true;
        if (appendOrder) {
            for (Parameter p : this.orderby) {
                if (flag) {
                    sb.append(" order by ");
                } else {
                    sb.append(",");
                }
                flag = false;
                if (pm != null) {
                    sb.append(String.format("%s %s", pm.getFieldDBName(p.getName()), p.getValue()));
                    continue;
                }
                sb.append(String.format("%s %s", p.getName(), p.getValue()));
            }
        }
        return sb.toString();
    }

    private List<Parameter> buildParameter() {
        if (this.params.size() == 0) {
            this.buildWhereClause();
        }
        ArrayList<Parameter> result = null;
        for (Clause c : this.variables) {
            if (result == null) {
                result = new ArrayList<Parameter>();
            }
            result.add(new Parameter(c.getVariable(), c.getValue()));
        }
        if (result == null) {
            return this.params;
        }
        result.addAll(this.params);
        return result;
    }

    public MpaasQuery or() {
        this.clauseConjuction = "or";
        return this;
    }

    public MpaasQuery and() {
        this.clauseConjuction = "and";
        return this;
    }

    public MpaasQuery conjuctionAnd() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "and"));
        return this;
    }

    public MpaasQuery groupBegin() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "("));
        return this;
    }

    public MpaasQuery groupEnd() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), ")"));
        return this;
    }

    public MpaasQuery conjuctionOr() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "or"));
        return this;
    }

    public MpaasQuery fileName(String excelFileName) {
        this.excelFileName = excelFileName;
        return this;
    }

    private String calculateConjunction(Integer position) {
        String result = "";
        for (int i = 0; i < this.groupConIndex.size(); ++i) {
            ConjunctionPosition p = this.groupConIndex.get(i);
            if (p.getPos() != position.intValue() || p.isHit() || !p.isConjunction()) continue;
            if (p.getPos() > position) break;
            p.setHit(true);
            result = ")" + p.getConjunction() + "(";
        }
        boolean hit = false;
        for (int i = 0; i < this.groupConIndex.size(); ++i) {
            ConjunctionPosition p = this.groupConIndex.get(i);
            if (p.getPos() != position.intValue() || p.isHit() || p.isConjunction()) {
                if (!"LEFT".equals(p.getType())) continue;
                hit = p.isHit();
                continue;
            }
            if (p.getPos() > position) break;
            p.setHit(true);
            if ("LEFT".equals(p.getType())) {
                result = result + "(";
                continue;
            }
            if (!hit) continue;
            result = ")" + result;
        }
        return result;
    }

    private boolean isEnd() {
        if (this.groupConIndex.size() == 0) {
            return true;
        }
        ConjunctionPosition con = this.groupConIndex.get(this.groupConIndex.size() - 1);
        if ("RIGHT".equals(con.getType()) && !con.isHit()) {
            for (int i = this.groupConIndex.size() - 1; i >= 0; --i) {
                ConjunctionPosition c = this.groupConIndex.get(i);
                if (!"LEFT".equals(c.getType()) || !c.isHit()) continue;
                return false;
            }
        }
        return true;
    }

    private String buildWhereClausePost(String sql) {
        String v = sql.replaceAll("\\(\\s+or\\s+", "(");
        v = v.replaceAll("\\(\\s+and\\s+", "(");
        v = v.replaceAll("\\(\\s*\\)", " ");
        v = v.replaceAll("^where\\s*or", "where ");
        v = v.replaceAll("^where\\s*and", "where ");
        if (!this.isEnd()) {
            v = v + ")";
        }
        return v;
    }

    private <T> List<T> postQuery(List<T> result) {
        if (result == null) {
            return result;
        }
        for (T item : result) {
            if (!(item instanceof MpaasBasePojo)) continue;
            ((MpaasBasePojo)item).encryptRowId(this.getRowIdSecret());
        }
        return result;
    }

    public Object decryptRowId(String content, Class clazz) {
        String s = MpaasQueryUtil.decryptRowId(content, this.getRowIdSecret());
        if (clazz == Integer.class) {
            return Integer.parseInt(s);
        }
        if (clazz == Long.class) {
            return Long.parseLong(s);
        }
        return s;
    }

    public MpaasQuery include(String ... fields) {
        if (this.includeFields == null) {
            this.includeFields = new HashSet<String>();
        }
        for (String s : Arrays.asList(fields)) {
            this.includeFields.add(s.toUpperCase());
        }
        return this;
    }

    public MpaasQuery exclude(String ... fields) {
        if (this.excludeFields == null) {
            this.excludeFields = new HashSet<String>();
        }
        for (String s : Arrays.asList(fields)) {
            this.excludeFields.add(s.toUpperCase());
        }
        return this;
    }

    public MpaasQuery select(String ... fields) {
        Set<String> sf = this.getSelectFields();
        for (String s : Arrays.asList(fields)) {
            sf.add(s);
        }
        return this;
    }

    public MpaasQuery unSelect(String ... fields) {
        Set<String> sf = this.getUnSelectFields();
        for (String s : Arrays.asList(fields)) {
            sf.add(s.toLowerCase());
        }
        return this;
    }

    public MpaasQuery unSelect(String s) {
        return this.unSelect(s.split(","));
    }

    public MpaasQuery select(String s) {
        return this.select(s.split(","));
    }

    private String buildSqlBySelectFields() {
        if (this.buildFinalSelectFields().size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("select ");
        PojoMeta pm = this.getPojoMetaInfo();
        Assert.notNull((Object)this.getTableName(), (String)"table name is null");
        boolean flag = false;
        for (String s : this.getSelectFields()) {
            if (flag) {
                sb.append(",");
            }
            flag = true;
            if ("*".equals(s)) {
                sb.append(s);
                continue;
            }
            sb.append(pm == null ? s : pm.getFieldDBName(s));
        }
        sb.append(" from");
        sb.append(" " + (this.viewQueryMode ? this.viewName : this.getTableName()));
        return sb.toString();
    }

    private Set<String> buildFinalSelectFields() {
        Set<String> sf = this.getSelectFields();
        PojoMeta pm = this.getPojoMetaInfo();
        if (sf.isEmpty()) {
            if (!this.viewQueryMode && pm != null) {
                for (PojoField f : pm.getDatabaseFields()) {
                    sf.add(f.getSqlColumnName(this.upper2Underline));
                }
            } else {
                sf.add("*");
            }
        }
        if (!this.viewQueryMode) {
            for (String s : this.getUnSelectFields()) {
                PojoField f = pm.findPojoField(s);
                if (f == null) {
                    throw new MpaasRuntimeException("can not find field %s", s);
                }
                Iterator<String> iterator = sf.iterator();
                while (iterator.hasNext()) {
                    if (!f.getSqlColumnName(this.upper2Underline).equalsIgnoreCase(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }
        return sf;
    }

    private Set<String> getSelectFields() {
        if (this.selectFields == null) {
            this.selectFields = new HashSet<String>();
        }
        return this.selectFields;
    }

    private Set<String> getUnSelectFields() {
        if (this.unSelectFields == null) {
            this.unSelectFields = new HashSet<String>();
        }
        return this.unSelectFields;
    }

    private String buildSelectSql() {
        if (MpaasUtil.strEmpty(this.sql)) {
            this.sql = this.buildSqlBySelectFields();
            if (MpaasUtil.strEmpty(this.sql) && this.viewQueryMode) {
                Assert.notNull((Object)this.viewName, (String)"view name is null");
                this.sql = this.getPojoMetaInfo().getSqlQuerys().get(this.viewName).sql();
                return this.sql;
            }
        }
        Assert.notNull((Object)this.sql, (String)"sql is null");
        this.sql = this.viewQuerySQLConvert(this.sql);
        this.sql = this.variableSQLConvert(this.sql);
        return this.sql;
    }

    private String viewQuerySQLConvert(String sql) {
        PojoMeta pm = this.getPojoMetaInfo();
        if (this.viewQueryMode && !this.viewConverted) {
            sql = SQLUtil.replaceWithQuerySQL(sql, pm.getSqlQuerys());
            this.viewConverted = true;
        }
        return sql;
    }

    private String variableSQLConvert(String sql) {
        Object[] clauses = this.variables.toArray(new Clause[this.variables.size()]);
        if (clauses.length > 1) {
            Arrays.sort(clauses);
        }
        for (Object c : clauses) {
            String s = String.format(this.getVariableFormat(), ((Clause)c).getVariable());
            sql = sql.replaceAll("#" + ((Clause)c).getField(), s);
        }
        return sql;
    }

    public MpaasQuery like(String field, String value) {
        return this.addClause(field, "like", value);
    }

    public MpaasQuery like(String field, String value, Boolean reverse) {
        return this.addClause(reverse, field, "like", value);
    }

    public MpaasQuery rlike(String field, String value) {
        return this.addClause(field, "rlike", value);
    }

    public MpaasQuery likeNocase(String field, String value) {
        return this.addClause(field, "like no case", value);
    }

    public MpaasQuery likeNocase(String field, String value, Boolean reverse) {
        return this.addClause(reverse, field, "like no case", value);
    }

    public MpaasQuery notLike(String field, String value) {
        return this.addClause(field, "not like", value);
    }

    public MpaasQuery notLike(String field, String value, Boolean reverse) {
        return this.addClause(reverse, field, "not like", value);
    }

    public MpaasQuery startWith(String field, String value) {
        return this.addClause(field, "^", value);
    }

    public MpaasQuery endWith(String field, String value) {
        return this.addClause(field, "$", value);
    }

    public MpaasQuery eq(String field, Object value) {
        return this.addClause(field, "=", value);
    }

    public MpaasQuery eqNocase(String field, Object value) {
        return this.addClause(field, "eq no case", value);
    }

    public MpaasQuery ne(String field, Object value) {
        return this.addClause(field, "!=", value);
    }

    public MpaasQuery lt(String field, Object value) {
        return this.addClause(field, "<", value);
    }

    public MpaasQuery gt(String field, Object value) {
        return this.addClause(field, ">", value);
    }

    public MpaasQuery lteq(String field, Object value) {
        return this.addClause(field, "<=", value);
    }

    public MpaasQuery gteq(String field, Object value) {
        return this.addClause(field, ">=", value);
    }

    public MpaasQuery isNull(String field) {
        return this.addClause(field, "is null", new Object[0]);
    }

    public MpaasQuery isNotNull(String field) {
        return this.addClause(field, "is not null", new Object[0]);
    }

    public MpaasQuery in(String field, Object ... values) {
        return this.addClause(field, "in", values);
    }

    public MpaasQuery in(String field, Collection values) {
        if (values != null) {
            this.addClause(field, "in", values.toArray());
        }
        return this;
    }

    public MpaasQuery notIn(String field, Object ... values) {
        return this.addClause(field, "not in", values);
    }

    public MpaasQuery notIn(String field, Collection values) {
        if (values != null) {
            this.addClause(field, "not in", values.toArray());
        }
        return this;
    }

    public MpaasQuery distinct(String fields) {
        this.distinct = fields;
        return this;
    }

    public Object callFunction(String funName, Object ... paramAndResult) {
        List<Object> result = this.dbAdapter.executeProcedure("FUNCTION", funName, paramAndResult);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<Object> callProcedure(String procName, Object ... paramAndResult) {
        return this.dbAdapter.executeProcedure("PROCEDURE", procName, paramAndResult);
    }

    public void doMerge(Object item) {
        this.bind(item);
        PojoField idField = this.getPojoMetaInfo().getRowIdField();
        if (item instanceof BasePojo && ((BasePojo)item).pojoId() != null || idField != null && idField.getValue(item) != null) {
            this.doUpdate(item);
            return;
        }
        this.doInsert(item);
    }

    public MpaasQuery setVar(String name, Object value) {
        if (value == null) {
            throw new MpaasRuntimeException("variable %s is null", name);
        }
        Clause c = new Clause(name, value);
        c.setVariable("va_" + name);
        this.variables.add(c);
        return this;
    }

    public MpaasQuery setOriginVar(String name, Object value) {
        if (value == null) {
            throw new MpaasRuntimeException("variable %s is null", name);
        }
        Clause c = new Clause(name, value);
        c.setVariable(name);
        this.variables.add(c);
        return this;
    }

    private String[] getUpdateFieldNames() {
        if ((this.updateFieldNames == null || this.updateFieldNames.length == 0) && this.updateField != null && this.updateField.size() > 0) {
            this.updateFieldNames = new String[this.updateField.size()];
            for (int i = 0; i < this.updateFieldNames.length; ++i) {
                this.updateFieldNames[i] = this.updateField.get(i).getField();
            }
        }
        return this.updateFieldNames;
    }

    private boolean isBatchInsert() {
        return this.pojo != null && this.pojo instanceof Collection;
    }

    public QueryInfo buildQueryInfo() {
        QueryInfo info = new QueryInfo();
        info.setTable(this.getTableName());
        info.setClauses(this.clauses);
        info.setRowId(this.rowid);
        info.setPojoClazz(this.pojoClazz);
        info.setPojo(this.pojo);
        info.setOrderby(this.orderby);
        info.setPage(this.page);
        info.setPageSize(this.pageSize);
        info.setGroupConIndex(this.groupConIndex);
        info.setPojoMeta(this.getPojoMetaInfo());
        info.setDistinct(this.distinct);
        info.setUpdateField(this.updateField);
        info.setSelectFields(this.selectFields);
        info.setFullUpdate(this.fullUpdate);
        info.setRowIdSecret(this.getRowIdSecret());
        info.setDbAdapter(this.dbAdapter);
        info.setDialect(this.dialect);
        info.setParams(this.params);
        info.setVariables(this.variables);
        info.setViewQueryMode(this.viewQueryMode);
        info.setUpper2Underline(this.upper2Underline);
        info.setTenantEnable(this.tenantEnable == null ? false : this.tenantEnable);
        info.setSchema(this.schema);
        if (this.plugins != null) {
            for (Plugin plugin : this.plugins) {
                info = plugin.execute(info, null).getQueryInfo();
            }
        }
        return info;
    }

    public void buildFromQueryInfo(QueryInfo info) {
        this.table = info.getTable();
        this.clauses = info.getClauses();
        this.rowid = info.getRowId();
        this.pojoClazz = info.getPojoClazz();
        this.pojo = info.getPojo();
        this.orderby = info.getOrderby();
        this.page = info.getPage();
        this.pageSize = info.getPageSize();
        this.groupConIndex = info.getGroupConIndex();
        this.pojoInfo = info.getPojoMeta();
        this.distinct = info.getDistinct();
        this.updateField = info.getUpdateField();
        this.selectFields = info.getSelectFields();
        this.fullUpdate = info.isFullUpdate();
        this.params = info.getParams();
        this.variables = info.getVariables();
        this.viewQueryMode = info.isViewQueryMode();
        this.upper2Underline = info.getUpper2Underline();
    }

    private Boolean isSqlDatabase() {
        return this.dbAdapter.isSqlDatabase();
    }

    private String getVariableFormat() {
        return this.dbAdapter.varformat();
    }

    private String getRowIdSecret() {
        return this.config.rowIdSecret;
    }

    public MpaasQuery templateSql(String sql) {
        this.templateSql = sql;
        return this;
    }

    public MpaasQuery tenant() {
        this.tenantEnable = true;
        return this;
    }

    public MpaasQuery tenant(String tenantId) {
        this.tenantEnable = true;
        this.tenantId = tenantId;
        return this;
    }

    public MpaasQuery noTenant() {
        this.tenantEnable = false;
        return this;
    }

    private void preQuery() {
        this.attachTenantQuery();
        this.filterSoftDeleteQuery();
    }

    private void attachTenantQuery() {
        if (!this.tenantEnable.booleanValue()) {
            return;
        }
        String f = this.getPojoMetaInfo().getTenantField();
        if (f != null) {
            this.eq(f, this.tenantId == null ? MpaasSession.getUserProfile().getTenantId() : this.tenantId);
        }
    }

    private void filterSoftDeleteQuery() {
        PojoMeta meta = this.getPojoMetaInfo();
        if (meta == null || !meta.isSoftDeleteEnable().booleanValue()) {
            return;
        }
        PojoField field = meta.getStateField();
        this.eq(field.getFieldName(), meta.getStateEnableString());
    }

    private Integer softDelete() {
        PojoMeta meta = this.getPojoMetaInfo();
        if (!meta.isSoftDeleteEnable().booleanValue()) {
            return 0;
        }
        PojoField field = meta.getStateField();
        this.eq(field.getFieldName(), meta.getStateEnableString());
        return this.update(field.getFieldName(), meta.getStateDisableString()).doUpdate();
    }

    private boolean softDeleteEnable() {
        return this.softDeleteEnable != false && this.getPojoMetaInfo().isSoftDeleteEnable() != false;
    }

    public MpaasQuery disableSoftDelete() {
        this.softDeleteEnable = false;
        return this;
    }

    public MpaasQuery enableSoftDelete() {
        this.softDeleteEnable = true;
        return this;
    }

    public MpaasQuery schema(String schema) {
        this.schema = schema;
        return this;
    }

    private String getTableName() {
        if (this.schema != null) {
            return this.schema + "." + this.table;
        }
        return this.table;
    }

    public MpaasQuery ignoreEmptyString(Boolean value) {
        if (value != null) {
            this.ignoreEmptyString = value;
        }
        return this;
    }
}

