/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import java.util.ArrayList;
import java.util.List;

public class Clause
implements Comparable<Clause> {
    public static final String AND = "and";
    public static final String OR = "or";
    private String field;
    private String variable;
    private String op;
    private List<Object> values;
    private Object tag;
    private String conjunction = "and";
    private String variableFormat = ":%s";
    private Boolean reverse;
    private int position;

    public Clause(String field, String op, String conjunction, Object ... value) {
        this.init(false, field, op, conjunction, value);
    }

    public Clause(Boolean reverse, String field, String op, String conjunction, Object ... value) {
        this.init(reverse, field, op, conjunction, value);
    }

    private void init(Boolean reverse, String field, String op, String conjunction, Object ... value) {
        this.field = field;
        this.reverse = reverse;
        this.conjunction = conjunction;
        this.op = op;
        if (value == null || value.length == 0) {
            this.addValue(null);
        } else {
            for (Object item : value) {
                this.addValue(item);
            }
        }
    }

    public String getVariableFormat() {
        return this.variableFormat;
    }

    public void setVariableFormat(String variableFormat) {
        this.variableFormat = variableFormat;
    }

    public Clause(String field, Object value) {
        this.field = field;
        this.addValue(value);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public Object getValue() {
        if (this.values != null && this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public void setValue(Object value) {
        if (this.values == null || this.values.size() == 0) {
            this.values = new ArrayList<Object>();
            this.values.add(value);
            return;
        }
        this.values.set(0, value);
    }

    public void addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        this.values.add(value);
    }

    public String getVariable() {
        if (this.variable == null) {
            return "v_" + this.field;
        }
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public String getConjunction() {
        return this.conjunction;
    }

    public void setConjunction(String conjunction) {
        this.conjunction = conjunction;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Boolean isReverse() {
        return this.reverse;
    }

    public Clause setReverse(Boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    @Override
    public int compareTo(Clause o) {
        if (o == null || o.getField() == null || this.getField() == null) {
            return 0;
        }
        return o.getField().length() - this.getField().length();
    }
}

