/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.mybatis.MybatisDatabaseAdapter;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.Sql2ODatabaseAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DatabaseAdapterFactory {
    @Autowired(required=false)
    private Sql2ODatabaseAdapter sql2ODatabaseAdapter;
    @Autowired(required=false)
    private MybatisDatabaseAdapter mybatisDatabaseAdapter;
    @Autowired(required=false)
    @Qualifier(value="NOSQL_ADAPTER")
    private DatabaseAdapter nosqlAdapter;
    @Autowired
    private SWordLogger logger;
    @Autowired
    private MpaasQueryConfig config;

    public DatabaseAdapter buildDatabaseAdapter() {
        return this.buildDatabaseAdapter(this.config.DB_ADAPTER);
    }

    public DatabaseAdapter buildDatabaseAdapter(String type) {
        if ("sql2o".equalsIgnoreCase(type)) {
            return this.sql2ODatabaseAdapter;
        }
        if ("mybatis".equalsIgnoreCase(type)) {
            return this.mybatisDatabaseAdapter;
        }
        if ("nosql".equalsIgnoreCase(type)) {
            return this.nosqlAdapter;
        }
        return this.sql2ODatabaseAdapter;
    }

    public DatabaseAdapter buildMultiDatasourceAdapter(String type) {
        if ("sql2o".equalsIgnoreCase(type) || "sql".equalsIgnoreCase(type) || "oracle".equalsIgnoreCase(type) || "mysql".equalsIgnoreCase(type)) {
            return new Sql2ODatabaseAdapter().config(this.config).logger(this.logger);
        }
        if ("mongodb".equalsIgnoreCase(type)) {
            return this.nosqlAdapter.createInstance(this.config, this.logger);
        }
        if ("nosql".equalsIgnoreCase(type)) {
            return this.nosqlAdapter.createInstance(this.config, this.logger);
        }
        return new Sql2ODatabaseAdapter().config(this.config).logger(this.logger);
    }
}

