/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasBusinessException;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.db.DatabaseDatasource;
import com.definesys.mpaas.query.db.StorageDatasource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class DatasourceContainer {
    public static final String LABEL = "mpaas.datasource";
    @Autowired
    private Environment env;
    private Map<String, StorageDatasource> storageDatasourceMap;

    public StorageDatasource findDatasource(String name) {
        return this.getStorageDatasourceMap().get(name);
    }

    public void addDatasource(DatabaseDatasource datasource) {
        this.getStorageDatasourceMap().put(datasource.getName(), this.toStorageDatasource(datasource));
    }

    public void addDatasource(String name, StorageDatasource datasource) {
        this.getStorageDatasourceMap().put(name, datasource);
    }

    private Map<String, StorageDatasource> getStorageDatasourceMap() {
        if (this.storageDatasourceMap == null) {
            this.storageDatasourceMap = new HashMap<String, StorageDatasource>();
            this.parseDatasource();
        }
        return this.storageDatasourceMap;
    }

    public void setStorageDatasourceMap(Map<String, StorageDatasource> storageDatasourceMap) {
        this.storageDatasourceMap = storageDatasourceMap;
    }

    private void parseDatasource() {
        String url;
        int index = 0;
        while ((url = this.env.getProperty(String.format("%s[%d].url", LABEL, index))) != null) {
            DatabaseDatasource ds = new DatabaseDatasource();
            ds.setUrl(url);
            ds.setName(this.envValue(index, "name"));
            ds.setPassword(this.envValue(index, "password"));
            ds.setType(this.envValue(index, "type"));
            ds.setUsername(this.envValue(index, "username"));
            this.getStorageDatasourceMap().put(ds.getName(), this.toStorageDatasource(ds));
            ++index;
        }
    }

    private String envValue(int index, String key) {
        String label = String.format("%s[%d].%s", LABEL, index, key);
        return this.env.getProperty(label);
    }

    public StorageDatasource toStorageDatasource(DatabaseDatasource ds) {
        StorageDatasource sds;
        if (this.storageDatasourceMap == null) {
            this.storageDatasourceMap = new HashMap<String, StorageDatasource>();
        }
        if ((sds = this.storageDatasourceMap.get(ds.getName())) == null) {
            if (!("sql".equals(ds.getType()) || "oracle".equalsIgnoreCase(ds.getType()) || "mysql".equalsIgnoreCase(ds.getType()))) {
                throw new MpaasBusinessException("type " + ds.getType() + " not support!!!");
            }
            sds = this.createJDBCDatasource(ds);
            sds.setType(ds.getType());
            this.storageDatasourceMap.put(sds.getId(), sds);
        }
        return sds;
    }

    public StorageDatasource createJDBCDatasource(DatabaseDatasource ds) {
        StorageDatasource sds = new StorageDatasource();
        sds.setId(ds.getName());
        if (ds.getJndi() != null) {
            JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
            bean.setJndiName(ds.getJndi());
            bean.setProxyInterface(DataSource.class);
            bean.setLookupOnStartup(false);
            try {
                bean.afterPropertiesSet();
                sds.setDatasource(bean.getObject());
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new MpaasRuntimeException(e);
            }
        } else {
            String driver = "oracle.jdbc.driver.OracleDriver";
            if ("oracle".equalsIgnoreCase(ds.getType())) {
                driver = "oracle.jdbc.driver.OracleDriver";
            } else if ("mysql".equalsIgnoreCase(ds.getType())) {
                driver = "com.mysql.jdbc.Driver";
            } else {
                throw new MpaasRuntimeException("not suuport type:" + ds.getType());
            }
            DataSource datasource = DataSourceBuilder.create().url(ds.getUrl()).username(ds.getUsername()).password(ds.getPassword()).driverClassName(driver).build();
            if (datasource instanceof HikariDataSource) {
                if (ds.getMinPoolSize() != null) {
                    ((HikariDataSource)datasource).addDataSourceProperty("minPoolSize", (Object)ds.getMinPoolSize());
                }
                if (ds.getMaxPoolSize() != null) {
                    ((HikariDataSource)datasource).addDataSourceProperty("maxPoolSize", (Object)ds.getMaxPoolSize());
                }
                if (ds.getConnectionTimeout() != null) {
                    ((HikariDataSource)datasource).addDataSourceProperty("connectionTimeout", (Object)ds.getConnectionTimeout());
                }
            }
            sds.setDatasource(datasource);
        }
        return sds;
    }
}

