/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.db.StorageDatasource;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.oracle.ProcedureExecutor;
import com.definesys.mpaas.query.util.ContextWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class DefaultDatabaseAdapter
implements DatabaseAdapter {
    @Autowired
    protected MpaasQueryConfig config;
    @Autowired(required=false)
    private DataSource dataSource;

    @Override
    public List<Object> executeProcedure(String funOrProc, String name, Object[] paramAndResult) {
        if (!"oracle".equalsIgnoreCase(this.config.getDBVendor())) {
            throw new UnsupportedOperationException("procedure only oracle database support");
        }
        List<Object> result = null;
        try {
            Connection connection = this.dataSource.getConnection();
            ProcedureExecutor executor = new ProcedureExecutor(connection);
            result = executor.call(funOrProc, name, paramAndResult);
            executor.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MpaasRuntimeException("executeProcedure error:" + e.getMessage());
        }
        return result;
    }

    @Override
    public List<Object> executeBatchInsert(QueryInfo queryInfo, String sql, List<List<Parameter>> paramsList, String ... keyColumns) {
        if (this.isSqlDatabase().booleanValue()) {
            DatabaseAdapterFactory factory = ContextWrapper.getAdapterFactory();
            DatabaseAdapter sql2o = factory.buildDatabaseAdapter("sql2o");
            return sql2o.executeBatchInsert(queryInfo, sql, paramsList, keyColumns);
        }
        return null;
    }

    @Override
    public void dataSource(StorageDatasource dataSource) {
    }

    @Override
    public Boolean isSqlDatabase() {
        return this.config.isSqlDatabase();
    }

    @Override
    public String varformat() {
        return this.config.getVariableFormat();
    }

    @Override
    public DatabaseAdapter createInstance(MpaasQueryConfig config, SWordLogger logger) {
        throw new MpaasRuntimeException("createInstance no implement");
    }
}

