/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.MySqlDialect;
import com.definesys.mpaas.query.db.OracleDialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DialectFactory {
    @Autowired
    private MpaasQueryConfig config;
    @Autowired(required=false)
    @Qualifier(value="NOSQL_DIALECT")
    private Dialect nosqlDialect;

    public Dialect buildDatabaseDialect() {
        String dbVendor = this.config.getDBVendor();
        return this.buildDatabaseDialect(dbVendor);
    }

    public Dialect buildMultiDatabaseDialect(String type) {
        return this.buildDatabaseDialect(type);
    }

    private Dialect buildDatabaseDialect(String type) {
        if ("Oracle".equalsIgnoreCase(type)) {
            return new OracleDialect();
        }
        if ("MySql".equalsIgnoreCase(type)) {
            return new MySqlDialect();
        }
        if ("MongoDB".equalsIgnoreCase(type)) {
            return this.nosqlDialect;
        }
        return new OracleDialect();
    }
}

