/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.annotation.RowIDType;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.RowIDInfo;
import com.definesys.mpaas.query.db.key.KeyValue;
import com.definesys.mpaas.query.util.SnowFlake;

public class OracleDialect
implements Dialect {
    public static final String PAGE_SQL_TEMPLATE = "select * from(select t.*,rownum rn from(%s)t where rownum<%d) where rn>=%d";

    @Override
    public ClauseSQL handleClause(Clause clause) {
        ClauseSQL cl = new ClauseSQL(ClauseSQL.VARIABLE);
        if (!("is null".equals(clause.getOp()) || "is not null".equals(clause.getOp()) || "var is null".equals(clause.getOp()) || "var is not null".equals(clause.getOp()) || clause != null && clause.getValues() != null && clause.getValues().get(0) != null)) {
            cl.setType(ClauseSQL.NONE);
            return cl;
        }
        String sql = null;
        String op = clause.getOp();
        String fmt = clause.getVariableFormat();
        if (fmt == null) {
            fmt = ":%s";
        }
        String var = String.format(fmt, clause.getVariable());
        String field = clause.getField();
        if ("like".equals(op)) {
            sql = clause.isReverse().booleanValue() ? String.format("instr(%s,%s)>0", var, field) : String.format("instr(%s,%s)>0", field, var);
        } else if ("like no case".equals(op)) {
            if (clause.getValue() instanceof String) {
                clause.setValue(((String)clause.getValue()).toUpperCase());
            }
            sql = clause.isReverse().booleanValue() ? String.format("instr(%s,UPPER(%s))>0", var, field) : String.format("instr(UPPER(%s),%s)>0", field, var);
        } else if ("=".equals(op)) {
            sql = String.format("%s = %s", field, var);
        } else if ("eq no case".equals(op)) {
            if (clause.getValue() instanceof String) {
                clause.setValue(((String)clause.getValue()).toUpperCase());
            }
            sql = String.format("UPPER(%s) = %s", field, var);
        } else if ("!=".equals(op)) {
            sql = String.format("%s <> %s", field, var);
        } else if (">".equals(op)) {
            sql = String.format("%s > %s", field, var);
        } else if (">=".equals(op)) {
            sql = String.format("%s >= %s", field, var);
        } else if ("<".equals(op)) {
            sql = String.format("%s < %s", field, var);
        } else if ("<=".equals(op)) {
            sql = String.format("%s <= %s", field, var);
        } else if ("^".equals(op)) {
            sql = String.format("%s like CONCAT('',concat(%s,'%%'))", field, var);
        } else if ("$".equals(op)) {
            sql = String.format("%s like CONCAT('%%',concat(%s,''))", field, var);
        } else if ("is null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is null", field);
        } else if ("is not null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is not null", field);
        } else if ("var is null".equals(op)) {
            sql = String.format("%s is null", clause.getVariable());
        } else if ("var is not null".equals(op)) {
            sql = String.format("%s is not null", clause.getVariable());
        } else if ("not like".equals(op)) {
            sql = clause.isReverse().booleanValue() ? String.format("instr(%s,%s)=0", var, field) : String.format("instr(%s,%s)=0", field, var);
        } else if ("in".equals(op) || "not in".equals(op)) {
            String s;
            StringBuffer sb = new StringBuffer();
            cl.setType(ClauseSQL.PURE);
            for (Object v : clause.getValues()) {
                if (v instanceof Iterable) {
                    for (Object v1 : (Iterable)v) {
                        if (v1 == null) continue;
                        this.append(sb, v1);
                    }
                    continue;
                }
                if (v == null) continue;
                this.append(sb, v);
            }
            String string = s = "in".equals(op) ? "in" : "not in";
            sql = sb.length() == 0 ? "1=1" : String.format("%s %s(%s)", clause.getField(), s, sb.toString());
        } else if ("between".equals(op)) {
            sql = String.format("%s between :%s_begin and :%s_end", clause.getField(), clause.getVariable(), clause.getVariable());
        } else if ("rlike".equals(op)) {
            sql = String.format("regexp_like(%s,%s)", field, var);
        }
        cl.setSqlClause(sql);
        return cl;
    }

    private void append(StringBuffer sb, Object v) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        if (v instanceof String) {
            sb.append("'");
            sb.append(v);
            sb.append("'");
        } else {
            sb.append(v);
        }
    }

    @Override
    public String buildPageQuery(String sql, Integer page, Integer pageSize) {
        if (page == null || pageSize == null) {
            return sql;
        }
        int begin = (page - 1) * pageSize + 1;
        int end = begin + pageSize;
        return String.format(PAGE_SQL_TEMPLATE, sql, end, begin);
    }

    @Override
    public KeyValue generateKey(String tableName, String column, RowIDInfo rowID) {
        RowIDType rowIDType = rowID.getType();
        KeyValue key = new KeyValue();
        if (rowIDType == RowIDType.SEQUENCE || rowIDType == RowIDType.AUTO) {
            String seq = rowID.getSequence();
            seq = MpaasUtil.strEmpty(seq) ? tableName + "_s.nextval" : seq + ".nextval";
            key.setStyle("SEQUENCE");
            key.setValue(seq);
            String sql = String.format("select %s from dual", seq);
            key.setStyle("SQL");
            key.setValue(sql);
            key.setTag(Long.class);
        } else if (rowIDType == RowIDType.UUID) {
            key.setStyle("VALUE");
            key.setValue(MpaasUtil.generateUniqueKey());
        } else if (rowIDType == RowIDType.SNOW) {
            key.setStyle("VALUE");
            key.setValue(SnowFlake.instance().nextId());
        } else {
            throw new MpaasRuntimeException("unsupport RowIDType:" + (Object)((Object)rowID.getType()));
        }
        return key;
    }
}

