/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db.key;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.key.KeyValue;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.util.TypeUtil;
import java.util.Collection;
import java.util.List;

public class KeyHandler {
    private Dialect dialect;
    private Object data;
    private String tableName;
    private PojoMeta meta;
    private Boolean upper2Underline;
    private DatabaseAdapter dbAdapter;
    private QueryInfo queryInfo;

    public KeyHandler(QueryInfo queryInfo) {
        this.dialect = queryInfo.getDialect();
        this.data = queryInfo.getPojo();
        this.tableName = queryInfo.getTable();
        this.meta = queryInfo.getPojoMeta();
        this.upper2Underline = queryInfo.getUpper2Underline();
        this.dbAdapter = queryInfo.getDbAdapter();
        this.queryInfo = queryInfo;
    }

    public void handler() {
        if (this.data instanceof Collection) {
            for (Object item : (Collection)this.data) {
                this.handleItem(item);
            }
        } else {
            this.handleItem(this.data);
        }
    }

    public void handleItem(Object item) {
        List<PojoField> fields = this.meta.getPojoFields();
        for (PojoField f : fields) {
            if (!f.isDBColumn().booleanValue()) continue;
            String propertyName = f.getSqlColumnName(this.upper2Underline);
            try {
                KeyValue keyValue = null;
                if (!f.isRowId().booleanValue() || "AUTOINCREMENT".equalsIgnoreCase((keyValue = this.dialect.generateKey(this.tableName, propertyName, f.getRowIDInfo())).getStyle())) continue;
                if ("VALUE".equals(keyValue.getStyle())) {
                    f.setValue(item, keyValue.getValue());
                    continue;
                }
                if (!"SQL".equalsIgnoreCase(keyValue.getStyle())) continue;
                List rs = this.dbAdapter.executeQuery(this.queryInfo, (String)keyValue.getValue(), null, (Class)keyValue.getTag());
                Object k = rs.get(0);
                if (f.getField() == null) {
                    f.setValue(item, k);
                    continue;
                }
                f.setValue(item, TypeUtil.convert(k, f.getField().getType()));
            }
            catch (Exception e) {
                throw new MpaasRuntimeException(e);
            }
        }
    }
}

