/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.executor;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.db.key.KeyHandler;
import com.definesys.mpaas.query.executor.DQMLExecutor;
import com.definesys.mpaas.query.executor.ExecuteResult;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.session.MpaasSession;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsertExecutor
implements DQMLExecutor {
    private QueryInfo queryInfo;
    private PojoMeta pm;
    private List<Parameter> params = new ArrayList<Parameter>();
    private List<List<Parameter>> batchParams = new ArrayList<List<Parameter>>();

    @Override
    public ExecuteResult execute(QueryInfo qi) {
        this.assertData(qi);
        this.init(qi);
        String sql = this.buildInsertSql();
        ExecuteResult<Object> rs = new ExecuteResult<Object>();
        if (this.isBatchInsert()) {
            List<Object> keys = qi.getDbAdapter().executeBatchInsert(qi, sql, this.batchParams, qi.getRowIDName());
            keys = this.pm.keysAssign(keys, qi.getPojo());
            rs.setData(keys);
        } else {
            Object key = qi.getDbAdapter().executeInsert(qi, sql, this.params, qi.getRowIDName());
            key = this.pm.keyAssign(key, qi.getPojo());
            rs.setData(key);
        }
        return rs;
    }

    private void init(QueryInfo qi) {
        this.setQueryInfo(qi);
        qi.setPojo(this.insertActionInit(qi.getPojo()));
        this.pm = qi.getPojoMeta();
        KeyHandler keyHandler = new KeyHandler(qi);
        if (this.isBatchInsert()) {
            Collection pojos = (Collection)this.queryInfo.getPojo();
            for (Object pojo : pojos) {
                keyHandler.handleItem(pojo);
            }
        } else {
            keyHandler.handleItem(this.queryInfo.getPojo());
        }
        this.paramBuild();
    }

    private Object insertActionInit(Object pojo) {
        if (pojo instanceof Collection) {
            for (Object item : (Collection)pojo) {
                this.insertActionInit(item);
            }
            return pojo;
        }
        String user = MpaasSession.getCurrentUser();
        try {
            for (PojoField f : this.queryInfo.getPojoMeta().getPojoFields()) {
                Method setMethod;
                SystemColumnType st = f.getSystemColumnType();
                if (st == null || (setMethod = f.setter()) == null) continue;
                if (SystemColumnType.CREATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    continue;
                }
                if (SystemColumnType.CREATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    continue;
                }
                if (SystemColumnType.OBJECT_VERSION == st) {
                    Class<?> types = setMethod.getParameterTypes()[0];
                    if (types == Long.class) {
                        setMethod.invoke(pojo, 1L);
                        continue;
                    }
                    if (types == Integer.class) {
                        setMethod.invoke(pojo, 1);
                        continue;
                    }
                    if (types == Double.class) {
                        setMethod.invoke(pojo, new Double(1.0));
                        continue;
                    }
                    if (types == Float.class) {
                        setMethod.invoke(pojo, new Float(1.0f));
                        continue;
                    }
                    throw new MpaasRuntimeException("pojo " + pojo.getClass() + " object version type must be Long or Integer");
                }
                if (SystemColumnType.OWNER == st) {
                    setMethod.invoke(pojo, user);
                    continue;
                }
                if (SystemColumnType.TENANT != st || MpaasSession.getUserProfile() == null) continue;
                setMethod.invoke(pojo, MpaasSession.getUserProfile().getTenantId());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pojo;
    }

    private void assertData(QueryInfo qi) {
        if (qi.getPojo() == null) {
            throw MpaasRuntimeException.fromCode("SW-180228", new Object[0]);
        }
    }

    private String buildInsertSql() {
        PojoMeta pm = this.getQueryInfo().getPojoMeta();
        List<PojoField> fields = pm.getPojoFields();
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        String varFormat = this.queryInfo.getDbAdapter().varformat();
        boolean isBatch = this.isBatchInsert();
        if (isBatch) {
            varFormat = ":%s";
        }
        for (PojoField f : fields) {
            if (!f.isDBColumn().booleanValue() || !isBatch && f.getValue(this.queryInfo.getPojo()) == null) continue;
            String propertyName = f.getSqlColumnName(this.queryInfo.getUpper2Underline());
            if (s1.length() > 0) {
                s1.append(",");
                s2.append(",");
            }
            s1.append(propertyName);
            s2.append(String.format(varFormat, propertyName));
        }
        String sql = String.format("insert into %s(%s)values(%s)", this.queryInfo.getTable(), s1.toString(), s2.toString());
        return sql;
    }

    private void paramBuild() {
        Object pojo = this.queryInfo.getPojo();
        List<PojoField> fields = this.pm.getPojoFields();
        boolean isBatch = this.isBatchInsert();
        if (isBatch) {
            Collection items = (Collection)pojo;
            for (Object item : items) {
                ArrayList<Parameter> p = new ArrayList<Parameter>();
                for (PojoField f : fields) {
                    if (!f.isDBColumn().booleanValue()) continue;
                    String propertyName = f.getSqlColumnName(this.queryInfo.getUpper2Underline());
                    Object value = f.getValue(item);
                    if (value != null && value instanceof String && ((String)value).length() == 0) {
                        value = null;
                    }
                    p.add(new Parameter(propertyName, value));
                }
                this.batchParams.add(p);
            }
        } else {
            for (PojoField f : fields) {
                if (!f.isDBColumn().booleanValue()) continue;
                String propertyName = f.getSqlColumnName(this.queryInfo.getUpper2Underline());
                Object value = f.getValue(pojo);
                if (value == null || value instanceof String && ((String)value).length() == 0) continue;
                this.params.add(new Parameter(propertyName, value));
            }
        }
    }

    private boolean isBatchInsert() {
        Object pojo = this.queryInfo.getPojo();
        return pojo != null && pojo instanceof Collection;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }
}

