/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.filter;

import com.definesys.mpaas.common.adapter.UserProfile;
import com.definesys.mpaas.query.session.MpaasSession;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class J2EEServletFilter
implements Filter {
    private String userHeaderName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.userHeaderName = filterConfig.getInitParameter("userHeaderName");
        if (this.userHeaderName == null) {
            this.userHeaderName = "uid";
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        UserProfile userProfile = null;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        request.setCharacterEncoding("utf-8");
        String uid = null;
        uid = request.getHeader(this.userHeaderName);
        if (uid == null) {
            uid = request.getHeader(this.userHeaderName.toUpperCase());
        }
        if (uid == null) {
            uid = "anonymous";
        }
        userProfile = new UserProfile();
        userProfile.setUid(uid);
        userProfile.setUserName(uid);
        userProfile.setToken(request.getHeader("Cookie"));
        Enumeration headers = request.getHeaderNames();
        HashMap<String, String> headerAttr = new HashMap<String, String>();
        while (headers.hasMoreElements()) {
            String label = (String)headers.nextElement();
            headerAttr.put(label, request.getHeader(label));
        }
        userProfile.setAttributes(headerAttr);
        MpaasSession.setUserProfile(userProfile);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

