/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.filter;

import com.definesys.mpaas.common.adapter.IMpaasSSOAuthentication;
import com.definesys.mpaas.common.adapter.UserProfile;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.session.MpaasSession;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MpaasFilter
implements Filter {
    @Autowired(required=false)
    private IMpaasSSOAuthentication ssoAuthentication;
    @Autowired
    private MpaasQueryConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        UserProfile userProfile = null;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if ("header".equalsIgnoreCase(this.config.securityMode) || this.ssoAuthentication == null) {
            String uid = request.getHeader(this.config.userHeaderName);
            userProfile = new UserProfile();
            userProfile.setAnonymous(false);
            if (uid == null) {
                uid = "anonymous";
                userProfile.setAnonymous(true);
            }
            userProfile.setUid(uid);
            userProfile.setUserName(uid);
        } else if ("custom".equalsIgnoreCase(this.config.securityMode)) {
            Cookie[] cookies = request.getCookies();
            HashMap<String, String> ck = null;
            if (cookies != null) {
                ck = new HashMap<String, String>();
                for (Cookie cookie : cookies) {
                    ck.put(cookie.getName(), cookie.getValue());
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String label = (String)headers.nextElement();
                hashMap.put(label, request.getHeader(label));
            }
            try {
                userProfile = this.ssoAuthentication.ssoAuth(hashMap, ck);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                userProfile = UserProfile.anonymous;
            }
        }
        if (this.config.useSecurity && userProfile.isAnonymous()) {
            String uri = request.getRequestURI();
            boolean bok = false;
            if (this.config.publicFilter != null) {
                for (String string : this.config.publicFilter.split(",")) {
                    if (!uri.matches(string)) continue;
                    bok = true;
                    break;
                }
            }
            if (!bok) {
                this.unAuthorized(servletResponse);
                return;
            }
        }
        MpaasSession.setUserProfile(userProfile);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void unAuthorized(ServletResponse servletResponse) {
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        try {
            res.getOutputStream().write("{\"code\":\"error\",\"message\":\"Unauthorized\"}".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.setStatus(401);
    }
}

