/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.link;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.MpaasQuery;
import com.definesys.mpaas.query.MpaasQueryFactory;
import com.definesys.mpaas.query.link.LinkDataType;
import com.definesys.mpaas.query.link.LinkFieldHandler;
import com.definesys.mpaas.query.link.LinkMap;
import com.definesys.mpaas.query.link.LinkResultSet;
import com.definesys.mpaas.query.link.NameValue;
import com.definesys.mpaas.query.link.WhereClause;
import com.definesys.mpaas.query.util.ContextWrapper;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkExecutor {
    private MpaasQueryFactory sw = ContextWrapper.getMpaasQueryFactory();
    private static final String FILTER_REX = "(\\w+)=#([^\\s]+)";
    private static Pattern PT_FILTER_COLUMN = Pattern.compile("(\\w+)=#([^\\s]+)", 32);
    private String table;
    private String where;
    private LinkMap maps = new LinkMap();
    private List<NameValue> variables = new ArrayList<NameValue>();
    private Object bindItem;
    private Class bindClazz;
    private LinkDataType bindType;
    private LinkDataType fieldType;
    private String executeSQL;
    private Boolean selectAll = false;
    private boolean simple = true;
    private List<WhereClause> whereColumns = new ArrayList<WhereClause>();

    public static LinkExecutor build(PojoField field, String column, String table, String where) {
        LinkExecutor info = new LinkExecutor();
        info.setTable(table);
        info.setWhere(where);
        info.addField(field, column);
        return info;
    }

    public void execute() {
        boolean bok;
        if (!this.validate()) {
            return;
        }
        boolean bl = bok = this.isListBind() ? this.buildListExecute() : this.buildItemExecute();
        if (!bok) {
            return;
        }
        MpaasQuery mq = this.sw.buildQuery().sql(this.executeSQL);
        for (NameValue item : this.variables) {
            mq.setOriginVar(item.getName(), item.getValue());
        }
        this.assignValueByType(new LinkResultSet(mq.doQuery()));
    }

    private boolean validate() {
        if (this.bindItem == null) {
            return false;
        }
        return this.bindType != LinkDataType.LIST || ((List)this.bindItem).size() != 0;
    }

    private boolean buildItemExecute() {
        PojoMeta meta = PojoCache.get(this.bindClazz);
        this.executeSQL = this.sql();
        for (WhereClause c : this.whereColumns) {
            PojoField f = meta.findPojoField(c.getField());
            Object value = f.getValue(this.bindItem);
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return false;
            }
            this.variables.add(new NameValue(c.getField(), value));
        }
        return true;
    }

    private boolean buildListExecute() {
        for (WhereClause c : this.whereColumns) {
            if (this.maps.containsKey(c.getColumn())) continue;
            this.maps.addColumnMap(c.getColumn(), null);
        }
        PojoMeta meta = PojoCache.get(this.bindClazz);
        Collection items = (Collection)this.bindItem;
        int effectiveSize = 0;
        for (Object item : items) {
            boolean bok = true;
            ArrayList<NameValue> nvs = new ArrayList<NameValue>();
            for (WhereClause c : this.whereColumns) {
                PojoField f = meta.findPojoField(c.getField());
                if (f == null) {
                    throw new MpaasRuntimeException("\u65e0\u6cd5\u627e\u5230\u67e5\u8be2\u5b57\u6bb5:" + c.getField());
                }
                Object v = f.getValue(item);
                if (v == null) {
                    bok = false;
                    break;
                }
                nvs.add(new NameValue(c.getField(), v));
            }
            if (!bok) continue;
            ++effectiveSize;
            for (NameValue nv : nvs) {
                nv.setName(nv.getName() + effectiveSize);
            }
            this.variables.addAll(nvs);
        }
        if (effectiveSize == 0) {
            return false;
        }
        this.executeSQL = this.batchSql(effectiveSize);
        return true;
    }

    private void assignValueByType(LinkResultSet resultSet) {
        if (this.fieldType == LinkDataType.LIST) {
            this.assignObjectValues(resultSet);
        } else {
            this.assignObjectValue(resultSet);
        }
    }

    private void assignObjectValues(LinkResultSet resultSet) {
        if (this.isListBind()) {
            List rows = (List)this.bindItem;
            PojoMeta meta = PojoCache.get(this.bindClazz);
            for (int i = 0; i < rows.size(); ++i) {
                Object item = rows.get(i);
                List<Map<String, Object>> resultList = null;
                if (this.simple) {
                    WhereClause cm = this.whereColumns.get(0);
                    Object v1 = meta.findPojoField(cm.getField()).getValue(item);
                    if (v1 == null) continue;
                    resultList = resultSet.getRowsByColumnFilter(cm.getColumn(), v1);
                } else {
                    int v1 = i + 1;
                    resultList = resultSet.getRowsByRowid(v1);
                }
                this.assignOneItemValues(item, resultList);
            }
        } else {
            this.assignOneItemValues(this.bindItem, resultSet.getResultList());
        }
    }

    private void assignObjectValue(LinkResultSet resultSet) {
        if (this.isListBind()) {
            List rows = (List)this.bindItem;
            PojoMeta meta = PojoCache.get(rows.get(0).getClass());
            for (int i = 0; i < rows.size(); ++i) {
                Object item = rows.get(i);
                Map<String, Object> row = null;
                if (this.simple) {
                    WhereClause cm = this.whereColumns.get(0);
                    Object v1 = meta.findPojoField(cm.getField()).getValue(item);
                    if (v1 == null) continue;
                    row = resultSet.getRowByColumnFilter(cm.getColumn(), v1);
                } else {
                    int v1 = i + 1;
                    row = resultSet.getRowByRowid(v1);
                }
                this.assignOneItemValue(item, row);
            }
        } else {
            this.assignOneItemValue(this.bindItem, resultSet.getOneResult());
        }
    }

    private void assignOneItemValue(Object item, Map<String, Object> row) {
        if (row == null) {
            return;
        }
        for (LinkFieldHandler fieldHandler : this.maps.getAllHandlers()) {
            if (fieldHandler == null) continue;
            fieldHandler.assignValue(item, row);
        }
    }

    private void assignOneItemValues(Object item, List<Map<String, Object>> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        Map<String, List<LinkFieldHandler>> fields = this.maps.groupByField();
        for (String c : fields.keySet()) {
            List<LinkFieldHandler> fs = fields.get(c);
            if (fs == null || fs.size() == 0) continue;
            fs.get(0).assignListValue(item, rows, fs);
        }
    }

    public void addField(PojoField field, String column) {
        String[] ss;
        LinkDataType t;
        LinkDataType linkDataType = t = field.isListType() != false ? LinkDataType.LIST : LinkDataType.BEAN;
        if (this.fieldType == null) {
            this.fieldType = t;
        }
        if (t != this.fieldType) {
            throw new MpaasRuntimeException("list and non list can not be in the same query");
        }
        if (MpaasUtil.strEmpty(column) && !field.isBasicType().booleanValue()) {
            this.selectAll = true;
            this.maps.addColumnMap(UUID.randomUUID().toString(), new LinkFieldHandler(null, null, field));
            return;
        }
        for (String s : ss = column.toLowerCase().split(",")) {
            String[] s1 = s.split("=");
            String javaField = null;
            String dbColumn = null;
            if (s1.length == 1) {
                javaField = dbColumn = s1[0].trim();
            } else {
                javaField = s1[0].trim();
                dbColumn = s1[1].trim();
            }
            if (field.isCamel()) {
                dbColumn = MpaasQueryUtil.camelConvert(dbColumn);
            }
            this.maps.addColumnMap(dbColumn, new LinkFieldHandler(dbColumn, javaField, field));
        }
    }

    public void merge(LinkExecutor lk) {
        LinkMap ms = lk.getMaps();
        if (lk.fieldType != this.fieldType) {
            throw new MpaasRuntimeException("list and non list can not be in the same query==>" + this.bindClazz);
        }
        if (!this.selectAll.booleanValue()) {
            this.selectAll = lk.selectAll;
        }
        this.maps.putAll(ms);
    }

    private LinkMap getMaps() {
        return this.maps;
    }

    public String key() {
        return this.table + "." + this.where + "." + (Object)((Object)this.fieldType);
    }

    public String sql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (this.selectAll.booleanValue()) {
            sql.append("t.*");
        } else {
            boolean flag = false;
            for (String f : this.maps.getAllColumnNames()) {
                if (flag) {
                    sql.append(",");
                }
                sql.append("t.");
                sql.append(f);
                flag = true;
            }
        }
        sql.append(" from ");
        sql.append(this.table);
        sql.append(" t");
        sql.append(" where ");
        sql.append(this.where);
        return sql.toString();
    }

    private String batchSql(int cnt) {
        if (this.simple) {
            return this.simpleBatchSql(cnt);
        }
        return this.complexBatchSql(cnt);
    }

    private String simpleBatchSql(int cnt) {
        StringBuffer buf = new StringBuffer();
        buf.append(" in(");
        for (int i = 0; i < cnt; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("#");
            buf.append(this.whereColumns.get(0).getField());
            buf.append(i + 1);
        }
        buf.append(")");
        String sql = this.sql();
        sql = sql.replaceAll("=#\\s*[^\\s]+", buf.toString());
        return sql;
    }

    private String complexBatchSql(int cnt) {
        String sql = this.sql();
        StringBuffer union = new StringBuffer();
        for (int i = 1; i <= cnt; ++i) {
            String s = sql.replaceAll("select", "select " + i + " as _rowid,");
            for (WhereClause c : this.whereColumns) {
                s = s.replaceAll("#" + c.getField(), "#" + c.getField() + i);
            }
            if (i > 1) {
                union.append("union all");
            }
            union.append("(");
            union.append(s);
            union.append(")");
        }
        return union.toString();
    }

    public LinkExecutor setTable(String table) {
        this.table = table;
        return this;
    }

    public LinkExecutor setWhere(String where) {
        this.where = where;
        this.simple = where.indexOf("#") == where.lastIndexOf("#");
        Matcher m = PT_FILTER_COLUMN.matcher(where);
        while (m.find()) {
            String f = m.group(2);
            if (f.startsWith("{")) {
                f = f.replaceAll("\\{", "");
                f = f.replaceAll("}", "");
            }
            this.whereColumns.add(new WhereClause(m.group(1), f));
        }
        return this;
    }

    public LinkExecutor bind(Object bindItem) {
        this.bindItem = bindItem;
        this.bindType = this.bindItem != null && this.bindItem instanceof List ? LinkDataType.LIST : LinkDataType.BEAN;
        this.bindClazz = this.isListBind() ? ((List)this.bindItem).get(0).getClass() : this.bindItem.getClass();
        return this;
    }

    private boolean isListBind() {
        return this.bindType == LinkDataType.LIST;
    }

    public LinkDataType getFieldType() {
        return this.fieldType;
    }
}

