/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.link;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.query.link.LinkDataType;
import com.definesys.mpaas.query.link.LinkHandler;
import com.definesys.mpaas.query.util.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

class LinkFieldHandler {
    private PojoField bindField;
    private PojoField parent;
    private LinkDataType type;
    private String columnName;

    public LinkFieldHandler(String columnName, String fieldName, PojoField field) {
        this.columnName = columnName;
        if (field.isBasicType().booleanValue()) {
            this.type = LinkDataType.BASIC;
            this.bindField = field;
        } else if (field.isObjectType().booleanValue()) {
            this.type = LinkDataType.BEAN;
            this.parent = field;
            if (fieldName != null) {
                this.bindField = PojoCache.get(this.parent.getField().getType()).findPojoField(fieldName);
            }
        } else if (field.isListType().booleanValue()) {
            this.parent = field;
            Class clazz = (Class)((ParameterizedTypeImpl)this.parent.getField().getGenericType()).getActualTypeArguments()[0];
            if (fieldName != null) {
                this.bindField = PojoCache.get(clazz).findPojoField(fieldName);
                LinkDataType linkDataType = this.type = this.bindField.isBasicType() != false ? LinkDataType.BASIC : LinkDataType.BEAN;
            }
        }
        if (this.bindField == null && fieldName != null) {
            throw new MpaasRuntimeException("can not find field==>" + fieldName);
        }
    }

    public void assignValue(Object item, Map<String, Object> row) {
        if (this.type == LinkDataType.BASIC) {
            Object value = row.get(this.columnName);
            this.bindField.setValue(item, value);
        } else if (this.type == LinkDataType.BEAN) {
            Object v = this.parent.getValue(item);
            if (v == null) {
                v = BeanUtil.convertMap(row, this.parent.getField().getType());
                this.parent.setValue(item, v);
            }
            if (this.bindField != null) {
                this.bindField.setValue(v, row.get(this.columnName));
            }
            LinkHandler handler = new LinkHandler();
            handler.loadLinkData(v);
        }
    }

    public void assignListValue(Object bindItem, List<Map<String, Object>> rows, List<LinkFieldHandler> fieldHandlers) {
        ArrayList items = new ArrayList();
        Class type = (Class)((ParameterizedTypeImpl)this.parent.getField().getGenericType()).getActualTypeArguments()[0];
        for (Map<String, Object> item : rows) {
            Object eo = BeanUtil.convertMap(item, type);
            for (LinkFieldHandler fieldHandler : fieldHandlers) {
                if (fieldHandler == null) continue;
                fieldHandler.assignValue(eo, item);
            }
            LinkHandler handler = new LinkHandler();
            handler.loadLinkData(eo);
            items.add(eo);
        }
        this.parent.setValue(bindItem, items);
    }

    public PojoField getParent() {
        return this.parent;
    }
}

