/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.link;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.annotation.DataFrom;
import com.definesys.mpaas.query.link.LinkExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LinkHandler {
    private Map<String, LinkExecutor> links;
    private Map<String, String> tableWhere;
    private boolean Initialized = false;

    public static LinkHandler build() {
        return new LinkHandler();
    }

    public void loadLinkData(Object data) {
        PojoMeta meta;
        Class<?> bindClazz = data.getClass();
        Object bindItem = data;
        if (data instanceof List) {
            if (((List)data).size() == 0) {
                return;
            }
            if (((List)data).size() == 1) {
                bindItem = ((List)data).get(0);
            }
            bindClazz = ((List)data).get(0).getClass();
        }
        if (!(meta = PojoCache.get(bindClazz)).haveJoin().booleanValue()) {
            return;
        }
        List<PojoField> fields = meta.getJoinFields();
        this.init(fields);
        for (PojoField f : fields) {
            DataFrom df = f.getDataFrom();
            if (df == null) continue;
            LinkExecutor lk = this.buildLinkInfo(f);
            LinkExecutor lk1 = this.links.get(lk.key());
            if (lk1 != null && lk1.getFieldType() == lk.getFieldType()) {
                lk1.merge(lk);
                continue;
            }
            lk.bind(bindItem);
            this.links.put(lk.key(), lk);
        }
        for (String s : this.links.keySet()) {
            this.links.get(s).execute();
        }
    }

    private void init(List<PojoField> fields) {
        if (this.Initialized) {
            return;
        }
        this.links = new HashMap<String, LinkExecutor>();
        this.tableWhere = new HashMap<String, String>();
        HashSet<String> confilics = new HashSet<String>();
        for (PojoField field : fields) {
            String table;
            DataFrom df = field.getDataFrom();
            String string = table = MpaasUtil.strEmpty(df.table()) ? null : df.table();
            if (table == null) {
                if (df.eo() != Object.class) {
                    table = PojoCache.get(df.eo()).getTableName();
                } else {
                    throw new MpaasRuntimeException("DataFrom Must Special eo or table :" + field.getFieldName());
                }
            }
            table = table.toLowerCase();
            String where = df.where();
            if (MpaasUtil.strEmpty(where)) continue;
            where = where.trim();
            String w = this.tableWhere.get(table);
            if (w == null && !confilics.contains(table)) {
                this.tableWhere.put(table, where);
                continue;
            }
            if (w != null && w.equals(where)) continue;
            confilics.add(table);
            this.tableWhere.remove(table);
        }
        this.Initialized = true;
    }

    private LinkExecutor buildLinkInfo(PojoField field) {
        DataFrom df = field.getDataFrom();
        LinkExecutor lk = null;
        if (df != null) {
            String column = df.column();
            String where = df.where();
            String table = this.tableName(df);
            if (MpaasUtil.strEmpty(column) && field.isBasicType().booleanValue()) {
                column = field.getColumnName();
            }
            if (MpaasUtil.strEmpty(where)) {
                where = this.tableWhere.get(table);
            }
            if (MpaasUtil.strEmpty(where)) {
                throw new MpaasRuntimeException("field %s Datafrom where is not specialed", field.getFieldName());
            }
            lk = LinkExecutor.build(field, column, table, where);
        }
        return lk;
    }

    private String tableName(DataFrom df) {
        String table;
        String string = table = MpaasUtil.strEmpty(df.table()) ? null : df.table();
        if (table == null && df.eo() != Object.class) {
            table = PojoCache.get(df.eo()).getTableName();
        }
        return table;
    }
}

