/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.link;

import com.definesys.mpaas.query.link.LinkFieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinkMap {
    private Map<String, List<LinkFieldHandler>> columnMap = new HashMap<String, List<LinkFieldHandler>>();

    public void addColumnMap(String columnName, LinkFieldHandler handler) {
        List<LinkFieldHandler> handlers = this.columnMap.get(columnName);
        if (handlers == null) {
            handlers = new ArrayList<LinkFieldHandler>();
        }
        handlers.add(handler);
        this.columnMap.put(columnName, handlers);
    }

    public boolean containsKey(String key) {
        return this.columnMap.get(key) != null;
    }

    public List<LinkFieldHandler> getAllHandlers() {
        ArrayList<LinkFieldHandler> hs = new ArrayList<LinkFieldHandler>();
        for (String k : this.columnMap.keySet()) {
            hs.addAll((Collection<LinkFieldHandler>)this.columnMap.get(k));
        }
        return hs;
    }

    public Set<String> getAllColumnNames() {
        return this.columnMap.keySet();
    }

    public void putAll(LinkMap m) {
        Map<String, List<LinkFieldHandler>> ms = m.columnMap;
        for (String k : ms.keySet()) {
            List<LinkFieldHandler> srcHandlers = ms.get(k);
            List<LinkFieldHandler> dstHandlers = this.columnMap.get(k);
            if (dstHandlers != null) {
                if (srcHandlers == null) continue;
                dstHandlers.addAll(srcHandlers);
                continue;
            }
            this.columnMap.put(k, srcHandlers);
        }
    }

    public Map<String, List<LinkFieldHandler>> groupByField() {
        HashMap<String, List<LinkFieldHandler>> handlers = new HashMap<String, List<LinkFieldHandler>>();
        for (String k : this.columnMap.keySet()) {
            List<LinkFieldHandler> v = this.columnMap.get(k);
            if (v == null || v.size() == 0 || v.size() == 1 && v.get(0) == null) continue;
            for (LinkFieldHandler f : v) {
                if (f == null || f.getParent() == null) continue;
                String name = f.getParent().getFieldName();
                ArrayList<LinkFieldHandler> v1 = (ArrayList<LinkFieldHandler>)handlers.get(name);
                if (v1 == null) {
                    v1 = new ArrayList<LinkFieldHandler>();
                }
                v1.add(f);
                handlers.put(name, v1);
            }
        }
        return handlers;
    }
}

