/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.link;

import com.definesys.mpaas.common.exception.MpaasBusinessException;
import com.definesys.mpaas.query.util.TypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinkResultSet {
    List<Map<String, Object>> resultSet;

    public LinkResultSet(List<Map<String, Object>> resultSet) {
        this.init(resultSet);
        this.resultSet = resultSet;
    }

    private void init(List<Map<String, Object>> resultSet) {
        if (resultSet == null) {
            return;
        }
        for (Map<String, Object> row : resultSet) {
            ArrayList<String> names = new ArrayList<String>();
            for (String key : row.keySet()) {
                String lowerKey = key.toLowerCase();
                if (lowerKey.equals(key)) continue;
                names.add(key);
            }
            for (String name : names) {
                row.put(name.toLowerCase(), row.get(name));
            }
        }
    }

    public Map<String, Object> getRowByColumnFilter(String column, Object value) {
        if (value == null) {
            return null;
        }
        boolean oneResult = true;
        Map<String, Object> row = null;
        String columnName = column.toLowerCase();
        for (Map<String, Object> r : this.resultSet) {
            Object v2 = TypeUtil.convert(r.get(columnName), value.getClass());
            if (!value.equals(v2)) continue;
            oneResult = row == null;
            row = r;
        }
        if (!oneResult) {
            throw new MpaasBusinessException("\u67e5\u8be2\u8d85\u8fc7\u4e00\u6761\u8bb0\u5f55\u4e0d\u80fd\u8fdb\u884c\u8d4b\u503c");
        }
        return row;
    }

    public Map<String, Object> getRowByRowid(Integer id) {
        return this.getRowByColumnFilter("_rowid", id);
    }

    public List<Map<String, Object>> getRowsByColumnFilter(String column, Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        String columnName = column.toLowerCase();
        for (Map<String, Object> r : this.resultSet) {
            Object v2 = TypeUtil.convert(r.get(columnName), value.getClass());
            if (!value.equals(v2)) continue;
            rows.add(r);
        }
        return rows;
    }

    public Map<String, Object> getOneResult() {
        if (this.resultSet.size() == 0) {
            return null;
        }
        this.assertOneResult();
        return this.resultSet.get(0);
    }

    public List<Map<String, Object>> getResultList() {
        return this.resultSet;
    }

    public List<Map<String, Object>> getRowsByRowid(Integer id) {
        return this.getRowsByColumnFilter("_rowid", id);
    }

    public Integer size() {
        return this.resultSet.size();
    }

    private void assertOneResult() {
        if (this.resultSet.size() > 1) {
            throw new MpaasBusinessException("\u67e5\u8be2\u8d85\u8fc7\u4e00\u6761\u8bb0\u5f55\u4e0d\u80fd\u8fdb\u884c\u8d4b\u503c");
        }
    }
}

