/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.oracle;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProcedureExecutor {
    private Connection connection;

    public ProcedureExecutor(Connection connection) {
        this.connection = connection;
    }

    public List<Object> call(String funOrProc, String name, Object[] paramAndResult) {
        ArrayList<Object> ps = new ArrayList<Object>();
        ArrayList<Class> clazz = new ArrayList<Class>();
        List<Object> result = new ArrayList<Object>();
        StringBuffer clobIndexStr = new StringBuffer();
        int clobIndex = 1;
        if (paramAndResult != null) {
            for (Object p : paramAndResult) {
                if (p instanceof Class) {
                    clazz.add((Class)p);
                    if (p != byte[].class) continue;
                    if (clobIndexStr.length() > 0) {
                        clobIndexStr.append(",");
                    }
                    clobIndexStr.append(clobIndex++);
                    continue;
                }
                ps.add(p);
                ++clobIndex;
            }
        }
        if ("FUNCTION".equalsIgnoreCase(funOrProc)) {
            Class c = clazz.size() == 0 ? String.class : (Class)clazz.get(0);
            result.add(this.transform(this.invokeFunction(name, clobIndex > 1, ps.toArray()), c));
        } else if ("PROCEDURE".equalsIgnoreCase(funOrProc)) {
            result = this.callStoreProcedure(name, clazz.size(), clobIndexStr.length() == 0 ? null : clobIndexStr.toString(), ps.toArray());
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, this.transform((String)result.get(i), (Class)clazz.get(i)));
            }
        }
        return result;
    }

    private String invokeFunction(String stmt, boolean clob, Object ... inParams) throws MpaasRuntimeException {
        CallableStatement st = null;
        String result = null;
        int size = inParams == null ? 0 : inParams.length;
        stmt = this.convertStmtWithParams(stmt, size);
        try {
            st = this.connection.prepareCall("{call ?:= " + stmt + "}");
            int i = 2;
            if (inParams != null && inParams.length > 0) {
                for (Object item : inParams) {
                    st.setObject(i, item);
                    ++i;
                }
            }
            st.registerOutParameter(1, clob ? 2005 : 12);
            st.execute();
            if (!clob) {
                result = st.getObject(1) == null ? "" : st.getObject(1).toString();
            } else {
                Clob cl = st.getClob(1);
                if (cl != null) {
                    result = cl.getSubString(1L, (int)cl.length());
                }
            }
            this.close(null, st, null);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new MpaasRuntimeException(String.format("execute function %s faield:%s", stmt, e.getMessage()));
            }
            catch (Throwable throwable) {
                this.close(null, st, null);
                throw throwable;
            }
        }
        return result;
    }

    private List<Object> callStoreProcedure(String stmt, int outParamsCount, String clobIndex, Object ... inParams) throws MpaasRuntimeException {
        ArrayList<Object> outParams = new ArrayList<Object>();
        CallableStatement st = null;
        int size = inParams == null ? 0 : inParams.length;
        size = outParamsCount + size;
        stmt = this.convertStmtWithParams(stmt, size);
        boolean[] clobFlag = null;
        if (clobIndex != null && inParams != null && inParams.length > 0) {
            clobFlag = new boolean[inParams.length + outParamsCount];
            for (int i = 0; i < clobFlag.length; ++i) {
                clobFlag[i] = false;
            }
            String[] strs = clobIndex.split(",");
            for (String s : strs) {
                int index = Integer.parseInt(s);
                clobFlag[index - 1] = true;
            }
        }
        try {
            int j;
            st = this.connection.prepareCall("begin " + stmt + "; end;");
            int i = 1;
            for (Object in : inParams) {
                st.setObject(i, in);
                ++i;
            }
            for (j = 0; j < outParamsCount; ++j) {
                if (clobIndex != null && clobFlag[i + j - 1]) {
                    st.registerOutParameter(i + j, 2005);
                    continue;
                }
                st.registerOutParameter(i + j, 12);
            }
            st.executeUpdate();
            for (j = 0; j < outParamsCount; ++j) {
                outParams.add(j, st.getString(i + j));
            }
            this.close(null, st, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new MpaasRuntimeException(String.format("call procedure:%s failed:%s", stmt, e.getMessage()));
            }
            catch (Throwable throwable) {
                this.close(null, st, null);
                throw throwable;
            }
        }
        return outParams;
    }

    private String convertStmtWithParams(String stmt, int paramCount) {
        StringBuffer buf = new StringBuffer(stmt);
        buf.append("(");
        for (int i = 0; i < paramCount; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    private void close(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> T transform(String value, Class<T> t) {
        T result = null;
        if (value == null || value.trim().length() == 0) {
            return result;
        }
        try {
            if (Long.class == t) {
                result = (T)Class.forName("java.lang.Long").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Integer.class == t) {
                result = (T)Class.forName("java.lang.Integer").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Double.class == t) {
                result = (T)Class.forName("java.lang.Integer").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Float.class == t) {
                result = (T)Class.forName("java.lang.Float").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            }
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException("cant convert from %s to type:%s", value, t.getName());
        }
        try {
            if (result == null) {
                result = (T)Class.forName("java.lang.String").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            }
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException("cant convert from %s to type:%s", value, t.getName());
        }
        return result;
    }

    public void close() {
        this.close(this.connection, null, null);
    }
}

