/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

public class Base32Util {
    private static final char[] ALPHABET;
    private static final byte[] DECODE_TABLE;

    public static String encode(byte[] data) {
        char[] chars = new char[data.length * 8 / 5 + (data.length % 5 != 0 ? 1 : 0)];
        int j = 0;
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (index > 3) {
                int b = data[j] & 255 >> index;
                index = (index + 5) % 8;
                b <<= index;
                if (j < data.length - 1) {
                    b |= (data[j + 1] & 0xFF) >> 8 - index;
                }
                chars[i] = ALPHABET[b];
                ++j;
                continue;
            }
            chars[i] = ALPHABET[data[j] >> 8 - (index + 5) & 0x1F];
            if ((index = (index + 5) % 8) != 0) continue;
            ++j;
        }
        return new String(chars);
    }

    public static byte[] decode(String s) throws Exception {
        char[] stringData = s.toCharArray();
        byte[] data = new byte[stringData.length * 5 / 8];
        int j = 0;
        int index = 0;
        for (int i = 0; i < stringData.length; ++i) {
            byte val;
            try {
                val = DECODE_TABLE[stringData[i]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new Exception("Illegal character");
            }
            if (val == 255) {
                throw new Exception("Illegal character");
            }
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = j++;
                    data[n] = (byte)(data[n] | val);
                    continue;
                }
                int n = j;
                data[n] = (byte)(data[n] | val << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = j++;
            data[n] = (byte)(data[n] | val >> index);
            if (j >= data.length) continue;
            int n2 = j;
            data[n2] = (byte)(data[n2] | val << 8 - index);
        }
        return data;
    }

    static {
        int i;
        ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
        DECODE_TABLE = new byte[128];
        for (i = 0; i < DECODE_TABLE.length; ++i) {
            Base32Util.DECODE_TABLE[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base32Util.DECODE_TABLE[Base32Util.ALPHABET[i]] = (byte)i;
            if (i >= 24) continue;
            Base32Util.DECODE_TABLE[Character.toLowerCase((char)Base32Util.ALPHABET[i])] = (byte)i;
        }
    }
}

