/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

import com.definesys.mpaas.query.util.MetaCache;
import com.definesys.mpaas.query.util.MetaInfo;
import com.definesys.mpaas.query.util.TypeUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BeanUtil {
    private static final MetaCache cache = new MetaCache();

    public static <T> List<T> convertArray(Collection items, Class<T> clazz) {
        if (items == null || items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object item : items) {
            result.add(BeanUtil.convert(item, clazz));
        }
        return result;
    }

    public static <T> T convert(Object src, Class<T> clazz) {
        T item = null;
        try {
            item = (T)Class.forName(clazz.getName()).newInstance();
            List<Field> fs = BeanUtil.getAllDeclaredFields(src.getClass());
            for (Field f : fs) {
                BeanUtil.setValue(item, f.getName(), BeanUtil.getValue(src, f.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public static <T> T convertMap(Map<String, Object> src, Class<T> clazz) {
        T item = null;
        try {
            item = (T)Class.forName(clazz.getName()).newInstance();
            for (String key : src.keySet()) {
                BeanUtil.setValue(item, key, src.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        if (clazz == Object.class) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Field> all = new ArrayList<Field>();
        all.addAll(Arrays.asList(clazz.getDeclaredFields()));
        all.addAll(BeanUtil.getAllDeclaredFields(clazz.getSuperclass()));
        return all;
    }

    public static Object getValue(Object src, String fieldName) {
        if (src == null) {
            return null;
        }
        MetaInfo meta = cache.get(src.getClass(), fieldName);
        Object value = null;
        try {
            Field field;
            value = meta.getGetter() != null ? meta.getGetter().invoke(src, new Object[0]) : ((field = meta.getField()) == null ? null : field.get(src));
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static void setValue(Object src, String fieldName, Object value) {
        if (src == null) {
            return;
        }
        MetaInfo meta = cache.get(src.getClass(), fieldName);
        if (meta.getField() == null) {
            return;
        }
        try {
            if (meta.getSetter() != null) {
                meta.getSetter().setAccessible(true);
                meta.getSetter().invoke(src, TypeUtil.convert(value, meta.getField().getType()));
            } else {
                meta.getField().setAccessible(true);
                meta.getField().set(src, TypeUtil.convert(value, meta.getField().getType()));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(BeanUtil.class.getName()).warning(String.format("\u65e0\u6cd5\u5b9e\u73b0 %s \u5230 %s \u7684\u503c\u8f6c\u6362\uff0c\u539f\u56e0:%s", value, src.getClass() + "." + fieldName, ex.getMessage()));
        }
    }
}

