/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

import com.definesys.mpaas.query.annotation.Alias;
import com.definesys.mpaas.query.util.MetaInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class MetaCache {
    private static Map<String, MetaInfo> metaCache = new HashMap<String, MetaInfo>();

    MetaCache() {
    }

    public MetaInfo get(Class clazz, String name) {
        String key = this.key(clazz, name);
        MetaInfo meta = metaCache.get(key);
        if (meta != null) {
            return meta;
        }
        return this.execute(clazz, name);
    }

    private MetaInfo execute(Class clazz, String name) {
        MetaInfo meta = new MetaInfo();
        meta.setFieldName(name);
        meta.setClazz(clazz);
        Field f = this.getField(clazz, name);
        if (f == null) {
            f = this.getAliasField(clazz, name);
        }
        if (f == null) {
            return meta;
        }
        name = f.getName();
        meta.setField(f);
        String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        String setter = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        meta.setGetter(this.getMethod(clazz, getter, new Class[0]));
        meta.setSetter(this.getMethod(clazz, setter, f.getType()));
        metaCache.put(this.key(clazz, name), meta);
        return meta;
    }

    private Field getAliasField(Class clazz, String name) {
        Field[] fs;
        if (clazz == Object.class) {
            return null;
        }
        for (Field f : fs = clazz.getDeclaredFields()) {
            String[] ss;
            Alias alias = f.getAnnotation(Alias.class);
            if (alias == null || alias.value() == null) continue;
            for (String s : ss = alias.value().split(",")) {
                if (!s.equals(name)) continue;
                return f;
            }
        }
        return this.getAliasField(clazz.getSuperclass(), name);
    }

    private Field getField(Class clazz, String name) {
        Field field;
        block4: {
            if (clazz == Object.class) {
                return null;
            }
            field = null;
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                Field[] fields = clazz.getDeclaredFields();
                String n1 = name.replaceAll("_", "").toLowerCase();
                for (Field f : fields) {
                    if (!f.getName().toLowerCase().equals(n1)) continue;
                    field = f;
                    break;
                }
                if (field != null) break block4;
                field = this.getField(clazz.getSuperclass(), name);
            }
        }
        return field;
    }

    private Method getMethod(Class clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        if (clazz == Object.class) {
            return null;
        }
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            method = this.getMethod(clazz.getSuperclass(), methodName, new Class[0]);
        }
        return method;
    }

    private String key(Class clazz, String name) {
        String key = clazz.getName() + "." + name;
        return key;
    }
}

