/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.AlternateShading;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.DataValidation;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

public class Worksheet {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    public static final int MAX_COL_WIDTH = 255;
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final List<DataValidation> dataValidations = new ArrayList<DataValidation>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private final Set<Integer> hiddenRows = new HashSet<Integer>();
    private final Map<Integer, Double> colWidths = new HashMap<Integer, Double>();
    private boolean finished;
    private boolean dataWrited = false;
    private Integer rowSize = 0;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r, int c) {
        if (r < 0 || r >= 0x100000 || c < 0 || c >= 16384) {
            throw new IllegalArgumentException();
        }
        while (r >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r);
        if (row == null) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            row = new Cell[columns];
            this.rows.set(r, row);
        } else if (c >= row.length) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r, row);
        }
        if (row[c] == null) {
            row[c] = new Cell();
        }
        return row[c];
    }

    void merge(Range range) {
        this.mergedRanges.add(range);
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheAlternateShadingFillColor(fill)));
    }

    void addValidation(DataValidation validation) {
        this.dataValidations.add(validation);
    }

    public void hideRow(int row) {
        this.hiddenRows.add(row);
    }

    public void showRow(int row) {
        this.hiddenRows.remove(row);
    }

    public void width(int c, double width) {
        if (width > 255.0) {
            throw new IllegalArgumentException();
        }
        this.colWidths.put(c, width);
    }

    public void value(int r, int c, Object value) {
        this.cell(r, c).setValue(this.workbook, value);
    }

    public Object value(int r, int c) {
        Cell[] row = r < this.rows.size() ? this.rows.get(r) : null;
        Cell cell = row == null || c >= row.length ? null : row[c];
        return cell == null ? null : cell.getValue();
    }

    public void formula(int r, int c, String expression) {
        this.cell(r, c).setFormula(expression);
    }

    public StyleSetter style(int r, int c) {
        return new Range(this, r, c, r, c).style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private boolean isCellInMergedRanges(int r, int c) {
        return this.mergedRanges.stream().filter(range -> range.contains(r, c)).findAny().isPresent();
    }

    private void writeCols(Writer w, int nbCols) throws IOException {
        boolean started = false;
        for (int c = 0; c < nbCols; ++c) {
            double maxWidth = 0.0;
            boolean bestFit = true;
            if (this.colWidths.containsKey(c)) {
                bestFit = false;
                maxWidth = this.colWidths.get(c);
            } else {
                for (int r = 0; r < this.rows.size(); ++r) {
                    Object o;
                    Object object = o = this.hiddenRows.contains(r) || this.isCellInMergedRanges(r, c) ? null : this.value(r, c);
                    if (o == null || o instanceof Formula) continue;
                    int length = o.toString().length();
                    maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
                }
            }
            if (!(maxWidth > 0.0)) continue;
            if (!started) {
                w.append("<cols>");
                started = true;
            }
            w.append("<col min=\"").append(c + 1).append("\" max=\"").append(c + 1).append("\" width=\"").append(Math.min(255.0, maxWidth)).append("\" customWidth=\"true\" bestFit=\"").append(String.valueOf(bestFit)).append("\"/>");
        }
        if (started) {
            w.append("</cols>");
        }
    }

    public void flush() throws IOException {
        Writer w = this.workbook.getWriter();
        if (!this.dataWrited) {
            this.dataWrited = true;
            int index = this.workbook.getIndex(this);
            this.workbook.openFile("xl/worksheets/sheet" + Integer.toString(index) + ".xml");
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(r -> r != null).map(r -> ((Cell[])r).length).reduce(0, Math::max);
            if (nbCols > 0) {
                this.writeCols(w, nbCols);
            }
            w.append("<sheetData>");
        }
        for (int r2 = 0; r2 < this.rows.size(); ++r2) {
            Cell[] row = this.rows.get(r2);
            if (row != null) {
                Worksheet.writeRow(w, this.rowSize, this.hiddenRows.contains(r2), row);
            }
            Worksheet worksheet = this;
            Integer.valueOf(worksheet.rowSize + 1);
            worksheet.rowSize = worksheet.rowSize;
        }
        this.rows.clear();
        w.flush();
    }

    public void finish() throws IOException {
        Writer w = this.workbook.getWriter();
        w.append("</sheetData>");
        if (!this.mergedRanges.isEmpty()) {
            w.append("<mergeCells>");
            for (Range r : this.mergedRanges) {
                w.append("<mergeCell ref=\"").append(r.toString()).append("\"/>");
            }
            w.append("</mergeCells>");
        }
        if (!this.dataValidations.isEmpty()) {
            w.append("<dataValidations count=\"").append(this.dataValidations.size()).append("\">");
            for (DataValidation v : this.dataValidations) {
                v.write(w);
            }
            w.append("</dataValidations>");
        }
        for (AlternateShading a : this.alternateShadingRanges) {
            a.write(w);
        }
        w.append("<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/></worksheet>");
        w.flush();
        this.rows.clear();
        this.finished = true;
    }

    private static void writeRow(Writer w, int r, boolean isHidden, Cell ... row) throws IOException {
        w.append("<row r=\"").append(r + 1);
        if (isHidden) {
            w.append("\" hidden=\"").append(String.valueOf(isHidden));
        }
        w.append("\">");
        for (int c = 0; c < row.length; ++c) {
            if (row[c] == null) continue;
            row[c].write(w, r, c);
        }
        w.append("</row>");
    }
}

