/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.sql2o.ArrayParameters;
import org.sql2o.Connection;
import org.sql2o.DefaultResultSetHandlerFactoryBuilder;
import org.sql2o.PojoResultSetIterator;
import org.sql2o.ResultSetHandler;
import org.sql2o.ResultSetHandlerFactory;
import org.sql2o.ResultSetHandlerFactoryBuilder;
import org.sql2o.ResultSetIterable;
import org.sql2o.Sql2oException;
import org.sql2o.converters.Convert;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.data.LazyTable;
import org.sql2o.data.Row;
import org.sql2o.data.Table;
import org.sql2o.data.TableResultSetIterator;
import org.sql2o.logging.LocalLoggerFactory;
import org.sql2o.logging.Logger;
import org.sql2o.quirks.Quirks;
import org.sql2o.reflection.PojoIntrospector;

public class Query
implements AutoCloseable {
    private static final Logger logger = LocalLoggerFactory.getLogger(Query.class);
    private Connection connection;
    private Map<String, String> caseSensitiveColumnMappings;
    private Map<String, String> columnMappings;
    private PreparedStatement preparedStatement = null;
    private boolean caseSensitive;
    private boolean autoDeriveColumnNames;
    private boolean throwOnMappingFailure = true;
    private String name;
    private boolean returnGeneratedKeys;
    private final String[] columnNames;
    private final Map<String, List<Integer>> paramNameToIdxMap;
    private final Map<String, ParameterSetter> parameters;
    private String parsedQuery;
    private int maxBatchRecords = 0;
    private int currentBatchRecords = 0;
    private ResultSetHandlerFactoryBuilder resultSetHandlerFactoryBuilder;

    public String toString() {
        return this.parsedQuery;
    }

    public Query(Connection connection, String queryText, boolean returnGeneratedKeys) {
        this(connection, queryText, returnGeneratedKeys, null);
    }

    public Query(Connection connection, String queryText, String[] columnNames) {
        this(connection, queryText, true, columnNames);
    }

    private Query(Connection connection, String queryText, boolean returnGeneratedKeys, String[] columnNames) {
        this.connection = connection;
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.columnNames = columnNames;
        this.setColumnMappings(connection.getSql2o().getDefaultColumnMappings());
        this.caseSensitive = connection.getSql2o().isDefaultCaseSensitive();
        this.paramNameToIdxMap = new HashMap<String, List<Integer>>();
        this.parameters = new HashMap<String, ParameterSetter>();
        this.parsedQuery = connection.getSql2o().getQuirks().getSqlParameterParsingStrategy().parseSql(queryText, this.paramNameToIdxMap);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Query setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public boolean isAutoDeriveColumnNames() {
        return this.autoDeriveColumnNames;
    }

    public Query setAutoDeriveColumnNames(boolean autoDeriveColumnNames) {
        this.autoDeriveColumnNames = autoDeriveColumnNames;
        return this;
    }

    public Query throwOnMappingFailure(boolean throwOnMappingFailure) {
        this.throwOnMappingFailure = throwOnMappingFailure;
        return this;
    }

    public boolean isThrowOnMappingFailure() {
        return this.throwOnMappingFailure;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.name;
    }

    public Query setName(String name) {
        this.name = name;
        return this;
    }

    public ResultSetHandlerFactoryBuilder getResultSetHandlerFactoryBuilder() {
        if (this.resultSetHandlerFactoryBuilder == null) {
            this.resultSetHandlerFactoryBuilder = new DefaultResultSetHandlerFactoryBuilder();
        }
        return this.resultSetHandlerFactoryBuilder;
    }

    public void setResultSetHandlerFactoryBuilder(ResultSetHandlerFactoryBuilder resultSetHandlerFactoryBuilder) {
        this.resultSetHandlerFactoryBuilder = resultSetHandlerFactoryBuilder;
    }

    public Map<String, List<Integer>> getParamNameToIdxMap() {
        return this.paramNameToIdxMap;
    }

    private void addParameterInternal(String name, ParameterSetter parameterSetter) {
        if (!this.getParamNameToIdxMap().containsKey(name)) {
            throw new Sql2oException("Failed to add parameter with name '" + name + "'. No parameter with that name is declared in the sql.");
        }
        this.parameters.put(name, parameterSetter);
    }

    private Object convertParameter(Object value) {
        if (value == null) {
            return null;
        }
        Converter<?> converter = this.getQuirks().converterOf(value.getClass());
        if (converter == null) {
            return value;
        }
        return converter.toDatabaseParam(value);
    }

    public <T> Query addParameter(String name, Class<T> parameterClass, T value) {
        if (InputStream.class.isAssignableFrom(parameterClass)) {
            return this.addParameter(name, (InputStream)value);
        }
        if (Integer.class == parameterClass) {
            return this.addParameter(name, (Integer)value);
        }
        if (Long.class == parameterClass) {
            return this.addParameter(name, (Long)value);
        }
        if (String.class == parameterClass) {
            return this.addParameter(name, (String)value);
        }
        if (Timestamp.class == parameterClass) {
            return this.addParameter(name, (Timestamp)value);
        }
        if (Time.class == parameterClass) {
            return this.addParameter(name, (Time)value);
        }
        if (parameterClass.isArray() && byte[].class != parameterClass) {
            return this.addParameter(name, Query.toObjectArray(value));
        }
        if (Collection.class.isAssignableFrom(parameterClass)) {
            return this.addParameter(name, (Collection)value);
        }
        final Object convertedValue = this.convertParameter(value);
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, convertedValue);
            }
        });
        return this;
    }

    public Query withParams(Object ... paramValues) {
        int i = 0;
        for (Object paramValue : paramValues) {
            this.addParameter("p" + ++i, paramValue);
        }
        return this;
    }

    public Query addParameter(String name, Object value) {
        return value == null ? this.addParameter(name, Object.class, null) : this.addParameter(name, value.getClass(), value);
    }

    public Query addParameter(String name, final InputStream value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final int value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Integer value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final long value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Long value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final String value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Timestamp value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Time value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final boolean value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Boolean value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final UUID value) {
        this.addParameterInternal(name, new ParameterSetter(){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, value);
            }
        });
        return this;
    }

    public Query addParameter(String name, final Object ... values) {
        if (values == null) {
            throw new NullPointerException("Array parameter cannot be null");
        }
        this.addParameterInternal(name, new ParameterSetter(values.length){

            @Override
            public void setParameter(int paramIdx, PreparedStatement statement) throws SQLException {
                if (values.length == 0) {
                    Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx, (Object)null);
                } else {
                    for (Object value : values) {
                        Query.this.getConnection().getSql2o().getQuirks().setParameter(statement, paramIdx++, value);
                    }
                }
            }
        });
        return this;
    }

    public Query addParameter(String name, Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("Array parameter cannot be null");
        }
        return this.addParameter(name, values.toArray());
    }

    public Query bind(Object pojo) {
        Class<?> clazz = pojo.getClass();
        Map<String, PojoIntrospector.ReadableProperty> propertyMap = PojoIntrospector.readableProperties(clazz);
        for (PojoIntrospector.ReadableProperty property : propertyMap.values()) {
            try {
                if (!this.getParamNameToIdxMap().containsKey(property.name)) continue;
                Class<?> type = property.type;
                this.addParameter(property.name, type, property.get(pojo));
            }
            catch (IllegalArgumentException ex) {
                logger.debug("Ignoring Illegal Arguments", ex);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (this.preparedStatement != null) {
            this.connection.removeStatement(this.preparedStatement);
            try {
                this.getQuirks().closeStatement(this.preparedStatement);
            }
            catch (Throwable ex) {
                logger.warn("Could not close statement.", ex);
            }
        }
    }

    PreparedStatement buildPreparedStatement() {
        return this.buildPreparedStatement(true);
    }

    private PreparedStatement buildPreparedStatement(boolean allowArrayParameters) {
        this.parsedQuery = ArrayParameters.updateQueryAndParametersIndexes(this.parsedQuery, this.paramNameToIdxMap, this.parameters, allowArrayParameters);
        if (this.preparedStatement == null) {
            try {
                this.preparedStatement = this.columnNames != null && this.columnNames.length > 0 ? this.connection.getJdbcConnection().prepareStatement(this.parsedQuery, this.columnNames) : (this.returnGeneratedKeys ? this.connection.getJdbcConnection().prepareStatement(this.parsedQuery, 1) : this.connection.getJdbcConnection().prepareStatement(this.parsedQuery));
            }
            catch (SQLException ex) {
                throw new Sql2oException(String.format("Error preparing statement - %s", ex.getMessage()), ex);
            }
            this.connection.registerStatement(this.preparedStatement);
        }
        for (Map.Entry<String, ParameterSetter> parameter : this.parameters.entrySet()) {
            for (int paramIdx : this.paramNameToIdxMap.get(parameter.getKey())) {
                try {
                    parameter.getValue().setParameter(paramIdx, this.preparedStatement);
                }
                catch (SQLException e) {
                    throw new RuntimeException(String.format("Error adding parameter '%s' - %s", parameter.getKey(), e.getMessage()), e);
                }
            }
        }
        this.parameters.clear();
        return this.preparedStatement;
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(Class<T> returnType) {
        ResultSetHandlerFactory<T> resultSetHandlerFactory = this.newResultSetHandlerFactory(returnType);
        return this.executeAndFetchLazy(resultSetHandlerFactory);
    }

    private <T> ResultSetHandlerFactory<T> newResultSetHandlerFactory(Class<T> returnType) {
        Quirks quirks = this.getConnection().getSql2o().getQuirks();
        ResultSetHandlerFactoryBuilder builder = this.getResultSetHandlerFactoryBuilder();
        if (builder == null) {
            builder = new DefaultResultSetHandlerFactoryBuilder();
        }
        builder.setAutoDeriveColumnNames(this.autoDeriveColumnNames);
        builder.setCaseSensitive(this.caseSensitive);
        builder.setColumnMappings(this.getColumnMappings());
        builder.setQuirks(quirks);
        builder.throwOnMappingError(this.throwOnMappingFailure);
        return builder.newFactory(returnType);
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(final ResultSetHandlerFactory<T> resultSetHandlerFactory) {
        final Quirks quirks = this.getConnection().getSql2o().getQuirks();
        return new ResultSetIterableBase<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PojoResultSetIterator(this.rs, Query.this.isCaseSensitive(), quirks, resultSetHandlerFactory);
            }
        };
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(ResultSetHandler<T> resultSetHandler) {
        ResultSetHandlerFactory<T> factory = Query.newResultSetHandlerFactory(resultSetHandler);
        return this.executeAndFetchLazy(factory);
    }

    private static <T> ResultSetHandlerFactory<T> newResultSetHandlerFactory(final ResultSetHandler<T> resultSetHandler) {
        return new ResultSetHandlerFactory<T>(){

            @Override
            public ResultSetHandler<T> newResultSetHandler(ResultSetMetaData resultSetMetaData) throws SQLException {
                return resultSetHandler;
            }
        };
    }

    public <T> List<T> executeAndFetch(Class<T> returnType) {
        return this.executeAndFetch(this.newResultSetHandlerFactory(returnType));
    }

    public <T> List<T> executeAndFetch(ResultSetHandler<T> resultSetHandler) {
        return this.executeAndFetch(Query.newResultSetHandlerFactory(resultSetHandler));
    }

    public <T> List<T> executeAndFetch(ResultSetHandlerFactory<T> factory) {
        ArrayList list = new ArrayList();
        try (ResultSetIterable<T> iterable = this.executeAndFetchLazy(factory);){
            for (Object item : iterable) {
                list.add(item);
            }
        }
        return list;
    }

    public <T> T executeAndFetchFirst(Class<T> returnType) {
        return this.executeAndFetchFirst(this.newResultSetHandlerFactory(returnType));
    }

    public <T> T executeAndFetchFirst(ResultSetHandler<T> resultSetHandler) {
        return this.executeAndFetchFirst(Query.newResultSetHandlerFactory(resultSetHandler));
    }

    public <T> T executeAndFetchFirst(ResultSetHandlerFactory<T> resultSetHandlerFactory) {
        try (ResultSetIterable<T> iterable = this.executeAndFetchLazy(resultSetHandlerFactory);){
            Iterator iterator = iterable.iterator();
            T t = iterator.hasNext() ? (T)iterator.next() : null;
            return t;
        }
    }

    public LazyTable executeAndFetchTableLazy() {
        final LazyTable lt = new LazyTable();
        lt.setRows((ResultSetIterable<Row>)new ResultSetIterableBase<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return new TableResultSetIterator(this.rs, Query.this.isCaseSensitive(), Query.this.getConnection().getSql2o().getQuirks(), lt);
            }
        });
        return lt;
    }

    public Table executeAndFetchTable() {
        ArrayList<Row> rows = new ArrayList<Row>();
        try (LazyTable lt = this.executeAndFetchTableLazy();){
            for (Row item : lt.rows()) {
                rows.add(item);
            }
            Table table = new Table(lt.getName(), rows, lt.columns());
            return table;
        }
    }

    public Connection executeUpdate() {
        long start = System.currentTimeMillis();
        try {
            this.logExecution();
            PreparedStatement statement = this.buildPreparedStatement();
            this.connection.setResult(statement.executeUpdate());
            this.connection.setKeys(this.returnGeneratedKeys ? statement.getGeneratedKeys() : null);
            this.connection.setCanGetKeys(this.returnGeneratedKeys);
        }
        catch (SQLException ex) {
            this.connection.onException();
            throw new Sql2oException("Error in executeUpdate, " + ex.getMessage(), ex);
        }
        finally {
            this.closeConnectionIfNecessary();
        }
        long end = System.currentTimeMillis();
        logger.debug("total: {} ms; executed update [{}]", new Object[]{end - start, this.getName() == null ? "No name" : this.getName()});
        return this.connection;
    }

    /*
     * Exception decompiling
     */
    public Object executeScalar() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Quirks getQuirks() {
        return this.connection.getSql2o().getQuirks();
    }

    public <V> V executeScalar(Class<V> returnType) {
        try {
            Converter<V> converter = Convert.throwIfNull(returnType, this.getQuirks().converterOf(returnType));
            this.logExecution();
            return this.executeScalar(converter);
        }
        catch (ConverterException e) {
            throw new Sql2oException("Error occured while converting value from database to type " + returnType, e);
        }
    }

    public <V> V executeScalar(Converter<V> converter) {
        try {
            return converter.convert(this.executeScalar());
        }
        catch (ConverterException e) {
            throw new Sql2oException("Error occured while converting value from database", e);
        }
    }

    public <T> List<T> executeScalarList(Class<T> returnType) {
        return this.executeAndFetch(this.newScalarResultSetHandler(returnType));
    }

    private <T> ResultSetHandler<T> newScalarResultSetHandler(final Class<T> returnType) {
        final Quirks quirks = this.getQuirks();
        try {
            final Converter<T> converter = Convert.throwIfNull(returnType, quirks.converterOf(returnType));
            return new ResultSetHandler<T>(){

                @Override
                public T handle(ResultSet resultSet) throws SQLException {
                    Object value = quirks.getRSVal(resultSet, 1);
                    try {
                        return converter.convert(value);
                    }
                    catch (ConverterException e) {
                        throw new Sql2oException("Error occurred while converting value from database to type " + returnType, e);
                    }
                }
            };
        }
        catch (ConverterException e) {
            throw new Sql2oException("Can't get converter for type " + returnType, e);
        }
    }

    public Query setMaxBatchRecords(int maxBatchRecords) {
        if (maxBatchRecords < 0) {
            throw new IllegalArgumentException("maxBatchRecords should be a nonnegative value");
        }
        this.maxBatchRecords = maxBatchRecords;
        return this;
    }

    public int getMaxBatchRecords() {
        return this.maxBatchRecords;
    }

    public int getCurrentBatchRecords() {
        return this.currentBatchRecords;
    }

    public boolean isExplicitExecuteBatchRequired() {
        return this.maxBatchRecords > 0 && this.currentBatchRecords > 0 || this.maxBatchRecords == 0;
    }

    public Query addToBatch() {
        try {
            this.buildPreparedStatement(false).addBatch();
            if (this.maxBatchRecords > 0 && ++this.currentBatchRecords % this.maxBatchRecords == 0) {
                this.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new Sql2oException("Error while adding statement to batch", e);
        }
        return this;
    }

    public <A> List<A> addToBatchGetKeys(Class<A> klass) {
        this.addToBatch();
        if (this.currentBatchRecords == 0) {
            return this.connection.getKeys(klass);
        }
        return Collections.emptyList();
    }

    public Connection executeBatch() throws Sql2oException {
        long start = System.currentTimeMillis();
        try {
            this.logExecution();
            PreparedStatement statement = this.buildPreparedStatement();
            this.connection.setBatchResult(statement.executeBatch());
            this.currentBatchRecords = 0;
            try {
                this.connection.setKeys(this.returnGeneratedKeys ? statement.getGeneratedKeys() : null);
                this.connection.setCanGetKeys(this.returnGeneratedKeys);
            }
            catch (SQLException sqlex) {
                throw new Sql2oException("Error while trying to fetch generated keys from database. If you are not expecting any generated keys, fix this error by setting the fetchGeneratedKeys parameter in the createQuery() method to 'false'", sqlex);
            }
        }
        catch (Throwable e) {
            this.connection.onException();
            throw new Sql2oException("Error while executing batch operation: " + e.getMessage(), e);
        }
        finally {
            this.closeConnectionIfNecessary();
        }
        long end = System.currentTimeMillis();
        logger.debug("total: {} ms; executed batch [{}]", new Object[]{end - start, this.getName() == null ? "No name" : this.getName()});
        return this.connection;
    }

    public Map<String, String> getColumnMappings() {
        if (this.isCaseSensitive()) {
            return this.caseSensitiveColumnMappings;
        }
        return this.columnMappings;
    }

    public Query setColumnMappings(Map<String, String> mappings) {
        this.caseSensitiveColumnMappings = new HashMap<String, String>();
        this.columnMappings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            this.caseSensitiveColumnMappings.put(entry.getKey(), entry.getValue());
            this.columnMappings.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        return this;
    }

    public Query addColumnMapping(String columnName, String propertyName) {
        this.caseSensitiveColumnMappings.put(columnName, propertyName);
        this.columnMappings.put(columnName.toLowerCase(), propertyName.toLowerCase());
        return this;
    }

    private void closeConnectionIfNecessary() {
        try {
            if (this.connection.autoClose) {
                this.connection.close();
            }
        }
        catch (Exception ex) {
            throw new Sql2oException("Error while attempting to close connection", ex);
        }
    }

    private void logExecution() {
        logger.debug("Executing query:{}{}", new Object[]{System.lineSeparator(), this.parsedQuery});
    }

    private static Object[] toObjectArray(Object val) {
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        int arrayLength = Array.getLength(val);
        Object[] outputArray = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    static abstract class ParameterSetter {
        int parameterCount;

        public ParameterSetter() {
            this(1);
        }

        ParameterSetter(int parameterCount) {
            this.parameterCount = parameterCount;
        }

        abstract void setParameter(int var1, PreparedStatement var2) throws SQLException;
    }

    private abstract class ResultSetIterableBase<T>
    implements ResultSetIterable<T> {
        private long start;
        private long afterExecQuery;
        protected ResultSet rs;
        boolean autoCloseConnection = false;

        public ResultSetIterableBase() {
            try {
                this.start = System.currentTimeMillis();
                Query.this.logExecution();
                this.rs = Query.this.buildPreparedStatement().executeQuery();
                this.afterExecQuery = System.currentTimeMillis();
            }
            catch (SQLException ex) {
                throw new Sql2oException("Database error: " + ex.getMessage(), ex);
            }
        }

        @Override
        public void close() {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    long afterClose = System.currentTimeMillis();
                    logger.debug("total: {} ms, execution: {} ms, reading and parsing: {} ms; executed [{}]", new Object[]{afterClose - this.start, this.afterExecQuery - this.start, afterClose - this.afterExecQuery, Query.this.name});
                    this.rs = null;
                }
            }
            catch (SQLException ex) {
                throw new Sql2oException("Error closing ResultSet.", ex);
            }
            finally {
                if (this.isAutoCloseConnection()) {
                    Query.this.connection.close();
                } else {
                    Query.this.closeConnectionIfNecessary();
                }
            }
        }

        @Override
        public boolean isAutoCloseConnection() {
            return this.autoCloseConnection;
        }

        @Override
        public void setAutoCloseConnection(boolean autoCloseConnection) {
            this.autoCloseConnection = autoCloseConnection;
        }
    }
}

