/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.EnumConverterFactory;

public class DefaultEnumConverterFactory
implements EnumConverterFactory {
    @Override
    public <E extends Enum> Converter<E> newConverter(final Class<E> enumType) {
        return new Converter<E>(){

            @Override
            public E convert(Object val) throws ConverterException {
                if (val == null) {
                    return null;
                }
                try {
                    if (val instanceof String) {
                        return Enum.valueOf(enumType, val.toString());
                    }
                    if (val instanceof Number) {
                        return ((Enum[])enumType.getEnumConstants())[((Number)val).intValue()];
                    }
                }
                catch (Throwable t) {
                    throw new ConverterException("Error converting value '" + val.toString() + "' to " + enumType.getName(), t);
                }
                throw new ConverterException("Cannot convert type '" + val.getClass().getName() + "' to an Enum");
            }

            @Override
            public Object toDatabaseParam(Enum val) {
                return val.name();
            }
        };
    }
}

