/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sql2o.ResultSetIteratorBase;
import org.sql2o.Sql2oException;
import org.sql2o.data.Column;
import org.sql2o.data.LazyTable;
import org.sql2o.data.Row;
import org.sql2o.quirks.Quirks;

public class TableResultSetIterator
extends ResultSetIteratorBase<Row> {
    private Map<String, Integer> columnNameToIdxMap = new HashMap<String, Integer>();
    private List<Column> columns = new ArrayList<Column>();

    public TableResultSetIterator(ResultSet rs, boolean isCaseSensitive, Quirks quirks, LazyTable lt) {
        super(rs, isCaseSensitive, quirks);
        try {
            lt.setName(this.meta.getTableName(1));
            for (int colIdx = 1; colIdx <= this.meta.getColumnCount(); ++colIdx) {
                String colName = this.getColumnName(colIdx);
                String colType = this.meta.getColumnTypeName(colIdx);
                this.columns.add(new Column(colName, colIdx - 1, colType));
                this.columnNameToIdxMap.put(colName, colIdx - 1);
            }
        }
        catch (SQLException e) {
            throw new Sql2oException("Error while reading metadata from database", e);
        }
        lt.setColumns(this.columns);
    }

    @Override
    protected Row readNext() throws SQLException {
        Row row = new Row(this.columnNameToIdxMap, this.columns.size(), this.isCaseSensitive, this.quirks);
        for (Column column : this.columns) {
            row.addValue(column.getIndex(), this.quirks.getRSVal(this.rs, column.getIndex() + 1));
        }
        return row;
    }
}

