/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks.parameterparsing.impl;

import java.util.List;
import java.util.Map;
import org.sql2o.quirks.parameterparsing.SqlParameterParsingStrategy;
import org.sql2o.quirks.parameterparsing.impl.CharParser;
import org.sql2o.quirks.parameterparsing.impl.DefaultParser;
import org.sql2o.quirks.parameterparsing.impl.DoubleHyphensCommentParser;
import org.sql2o.quirks.parameterparsing.impl.ForwardSlashCommentParser;
import org.sql2o.quirks.parameterparsing.impl.ParameterParser;
import org.sql2o.quirks.parameterparsing.impl.QuoteParser;

public class DefaultSqlParameterParsingStrategy
implements SqlParameterParsingStrategy {
    public CharParser[] getCharParsers(Map<String, List<Integer>> paramMap) {
        return new CharParser[]{new QuoteParser(), new DoubleHyphensCommentParser(), new ForwardSlashCommentParser(), new ParameterParser(paramMap), new DefaultParser()};
    }

    @Override
    public String parseSql(String statement, Map<String, List<Integer>> paramMap) {
        int length = statement.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        CharParser[] charParsers = this.getCharParsers(paramMap);
        block0: for (int idx = 0; idx < length; ++idx) {
            for (CharParser parser : charParsers) {
                char c = statement.charAt(idx);
                if (!parser.canParse(c, statement, idx)) continue;
                idx = parser.parse(c, idx, parsedQuery, statement, length);
                continue block0;
            }
        }
        return parsedQuery.toString();
    }
}

