/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V, E> {
    private final Map<K, V> map;
    private final Lock rl;
    private final Lock wl;
    Integer hit = 0;
    Integer unhit = 0;

    public AbstractCache(Map<K, V> map) {
        this.map = map;
        ReentrantReadWriteLock rrwl = new ReentrantReadWriteLock();
        this.rl = rrwl.readLock();
        this.wl = rrwl.writeLock();
    }

    public AbstractCache() {
        this(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, E param) {
        V value;
        try {
            this.rl.lock();
            value = this.map.get(key);
        }
        finally {
            this.rl.unlock();
        }
        if (value != null) {
            this.hit = this.hit + 1;
            return value;
        }
        try {
            this.wl.lock();
            value = this.map.get(key);
            if (value == null) {
                value = this.evaluate(key, param);
                this.map.put(key, value);
                this.unhit = this.unhit + 1;
            } else {
                this.hit = this.hit + 1;
            }
        }
        finally {
            this.wl.unlock();
        }
        return value;
    }

    public void printMemery() {
        Integer length = 0;
        for (K key : this.map.keySet()) {
            V v = this.map.get(key);
            if (!(v instanceof Map)) continue;
            Map m = (Map)v;
            for (Object k : m.keySet()) {
                Object v1 = m.get(k);
                if (!(v1 instanceof String)) continue;
                length = length + ((String)v1).length();
            }
        }
        System.out.println("cache size      =======>" + this.map.size());
        System.out.println("cache memory    =======>" + length);
        System.out.println("hit             =======>" + this.hit);
        System.out.println("unhit           =======>" + this.unhit);
    }

    protected abstract V evaluate(K var1, E var2);
}

