/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.tools;

import org.sql2o.tools.ClassUtils;

public final class FeatureDetector {
    private static Boolean jodaTimeAvailable;
    private static Boolean slf4jAvailable;
    private static Boolean oracleAvailable;
    private static boolean cacheUnderscoreToCamelcaseEnabled;

    private FeatureDetector() {
    }

    public static boolean isJodaTimeAvailable() {
        if (jodaTimeAvailable == null) {
            jodaTimeAvailable = ClassUtils.isPresent("org.joda.time.DateTime");
        }
        return jodaTimeAvailable;
    }

    public static boolean isSlf4jAvailable() {
        if (slf4jAvailable == null) {
            slf4jAvailable = ClassUtils.isPresent("org.slf4j.Logger");
        }
        return slf4jAvailable;
    }

    public static boolean isOracleAvailable() {
        if (oracleAvailable == null) {
            oracleAvailable = ClassUtils.isPresent("oracle.sql.TIMESTAMP");
        }
        return oracleAvailable;
    }

    public static boolean isCacheUnderscoreToCamelcaseEnabled() {
        return cacheUnderscoreToCamelcaseEnabled;
    }

    public static void setCacheUnderscoreToCamelcaseEnabled(boolean cacheUnderscoreToCamelcaseEnabled) {
        FeatureDetector.cacheUnderscoreToCamelcaseEnabled = cacheUnderscoreToCamelcaseEnabled;
    }

    static {
        FeatureDetector.setCacheUnderscoreToCamelcaseEnabled(true);
    }
}

