/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.cache;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.annotation.Column;
import com.definesys.mpaas.query.annotation.ColumnType;
import com.definesys.mpaas.query.annotation.Lookup;
import com.definesys.mpaas.query.annotation.RowID;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.annotation.SystemColumn;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.annotation.Tag;
import com.definesys.mpaas.query.db.RowIDInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.springframework.core.annotation.AliasFor;

public class PojoField {
    private Field field;
    private Boolean isRowId = false;
    private String sqlColumnName;
    private SystemColumnType systemColumnType;
    private Method getter;
    private Method setter;
    private String displayName;
    private ColumnType columnType = ColumnType.DB;
    private Style style;
    private JsonDeserialize deserialize;
    private Lookup lookup;
    private RowIDInfo rowIDInfo;

    public PojoField(Field f2, Method getter, Method setter) {
        this.field = f2;
        this.getter = getter;
        this.setter = setter;
        this.init();
    }

    public PojoField(String name) {
        this.sqlColumnName = name;
    }

    private void init() {
        String s2;
        RowID rowID = this.field.getAnnotation(RowID.class);
        if (rowID != null) {
            this.isRowId = true;
            this.rowIDInfo = new RowIDInfo(rowID);
        }
        if (this.field.getAnnotation(Column.class) != null && !MpaasUtil.strEmpty(s2 = this.field.getAnnotation(Column.class).value())) {
            this.sqlColumnName = s2;
        }
        if (this.field.getAnnotation(SystemColumn.class) != null) {
            this.systemColumnType = this.field.getAnnotation(SystemColumn.class).value();
        }
        this.displayName = this.field.getName();
        Column c2 = this.field.getAnnotation(Column.class);
        this.style = this.field.getAnnotation(Style.class);
        this.deserialize = this.field.getAnnotation(JsonDeserialize.class);
        this.parseLookup();
        if (c2 != null) {
            if (c2.display() != null && c2.display().trim().length() > 0) {
                this.displayName = c2.display();
            }
            if (c2.type() != null) {
                this.columnType = c2.type();
            }
        }
        if (this.style != null && !MpaasUtil.strEmpty(this.style.displayName())) {
            this.displayName = this.style.displayName();
        }
    }

    private Lookup parseLookup() {
        this.lookup = this.field.getAnnotation(Lookup.class);
        if (this.lookup == null) {
            Annotation[] annotations;
            for (Annotation a2 : annotations = this.field.getAnnotations()) {
                this.lookup = a2.annotationType().getAnnotation(Lookup.class);
                if (this.lookup == null) continue;
                Method[] methods = a2.annotationType().getDeclaredMethods();
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.lookup);
                Map memberValues = null;
                try {
                    Field declaredField = invocationHandler.getClass().getDeclaredField("memberValues");
                    declaredField.setAccessible(true);
                    memberValues = (Map)declaredField.get(invocationHandler);
                }
                catch (Exception e2) {
                    throw new MpaasRuntimeException(e2);
                }
                for (Method m2 : methods) {
                    AliasFor al = m2.getAnnotation(AliasFor.class);
                    if (al == null) continue;
                    String v2 = al.value();
                    try {
                        memberValues.put(v2, m2.invoke((Object)a2, new Object[0]));
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                if (this.lookup != null) break;
            }
        }
        return this.lookup;
    }

    public Object getTagValue() {
        Tag tag = this.field.getAnnotation(Tag.class);
        return tag == null ? null : tag.value();
    }

    public Object getValue(Object pojo) {
        if (pojo instanceof RowData) {
            return ((RowData)pojo).getValue(this.sqlColumnName);
        }
        if (this.getter != null) {
            try {
                return this.getter.invoke(pojo, new Object[0]);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InvocationTargetException e3) {
                e3.printStackTrace();
            }
        }
        return null;
    }

    public Object getFormatValue(Object pojo) {
        if (pojo == null) {
            return null;
        }
        Object value = this.getValue(pojo);
        String format = "yyyy/MM/dd";
        Object result = value;
        if (value instanceof Date) {
            if (this.style != null && !MpaasUtil.strEmpty(this.style.format())) {
                format = this.style.format();
            } else if (this.deserialize != null && "MpaasDateTimeDeserializer".equals(this.deserialize.using().getSimpleName())) {
                format = "yyyy/MM/dd HH:mm:ss";
            }
            result = new SimpleDateFormat(format).format((Date)value);
        }
        return result;
    }

    public void setValue(Object pojo, Object value) {
        if (pojo instanceof RowData) {
            ((RowData)pojo).setValue(this.sqlColumnName, value);
            return;
        }
        if (this.setter != null) {
            try {
                this.setter.invoke(pojo, value);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InvocationTargetException e3) {
                e3.printStackTrace();
            }
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Boolean isKeyField() {
        return this.isRowId;
    }

    public String getSqlColumnName(Boolean upper2Uderline) {
        if (this.sqlColumnName != null) {
            return this.sqlColumnName;
        }
        return upper2Uderline != false ? MpaasQueryUtil.upper2Underline(this.field.getName()) : this.field.getName();
    }

    public void setSqlColumnName(String sqlColumnName) {
        this.sqlColumnName = sqlColumnName;
    }

    public SystemColumnType getSystemColumnType() {
        return this.systemColumnType;
    }

    public void setSystemColumnType(SystemColumnType systemColumnType) {
        this.systemColumnType = systemColumnType;
    }

    public Method getter() {
        return this.getter;
    }

    public Method setter() {
        return this.setter;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean isRowId() {
        return this.isRowId;
    }

    public Boolean isDBColumn() {
        return this.columnType == ColumnType.DB;
    }

    public Boolean isQueryColumn() {
        return this.columnType == ColumnType.DB || this.columnType == ColumnType.CALCULATE;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void setRowId(Boolean rowId) {
        this.isRowId = rowId;
    }

    public RowIDInfo getRowIDInfo() {
        return this.rowIDInfo;
    }

    public void setRowIDInfo(RowIDInfo rowIDInfo) {
        if (rowIDInfo != null) {
            this.isRowId = true;
        }
        this.rowIDInfo = rowIDInfo;
    }

    public String getFieldName() {
        if (this.field != null) {
            return this.field.getName();
        }
        return this.sqlColumnName;
    }
}

