/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query;

import com.definesys.mpaas.cache.Cache;
import com.definesys.mpaas.cache.PojoField;
import com.definesys.mpaas.cache.PojoMeta;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.Clause;
import com.definesys.mpaas.query.ConjunctionPosition;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.DialectFactory;
import com.definesys.mpaas.query.db.KeyValue;
import com.definesys.mpaas.query.db.PageQueryResult;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.excel.MpaasExcel;
import com.definesys.mpaas.query.model.BasePojo;
import com.definesys.mpaas.query.model.MpaasBasePojo;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.definesys.mpaas.query.util.SQLUtil;
import com.definesys.mpaas.query.util.TypeUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MpaasQuery {
    private String sql;
    private String countSQL;
    private Integer page;
    private Integer pageSize;
    private String table;
    private Object pojo;
    private Class pojoClazz;
    private Boolean upper2Underline;
    private String clauseConjuction = "and";
    private String excelFileName;
    private Integer rowVersion;
    private String viewName;
    private boolean viewQueryMode = false;
    private boolean fullUpdate = true;
    private List<Clause> clauses = new ArrayList<Clause>();
    private List<Parameter> params = new ArrayList<Parameter>();
    private List<Clause> updateField = new ArrayList<Clause>();
    private List<Parameter> orderby = new ArrayList<Parameter>();
    private List<Clause> variables = new ArrayList<Clause>();
    private Set<String> selectFields;
    private Set<String> unSelectFields;
    private Set<String> includeFields;
    private Set<String> excludeFields;
    private String groupby;
    private String distinct;
    private Dialect dialect;
    private DatabaseAdapter dbAdapter;
    private String[] updateFieldNames;
    private String rowid;
    private PojoMeta pojoInfo;
    private List<ConjunctionPosition> groupConIndex = new ArrayList<ConjunctionPosition>();
    private boolean viewConverted = false;
    private MpaasQueryConfig config;
    private SWordLogger logger;
    private int clausePosition = 0;

    @Autowired
    public MpaasQuery(DialectFactory dialectFactory, DatabaseAdapterFactory databaseAdapterFactory, MpaasQueryConfig config, SWordLogger logger) {
        Dialect dialect;
        this.dialect = dialect = dialectFactory.buildDatabaseDialect();
        this.dbAdapter = databaseAdapterFactory.buildDatabaseAdapter();
        this.config = config;
        this.logger = logger;
        this.pageSize(this.config.PAGE_SIZE);
    }

    public MpaasQuery(Dialect dialect, DatabaseAdapter dbAdapter, MpaasQueryConfig config, SWordLogger logger) {
        this.dialect = dialect;
        this.dbAdapter = dbAdapter;
        this.config = config;
        this.logger = logger;
    }

    public MpaasQuery addClause(String name, String op, Object ... value) {
        value = this.preHandleValue(value);
        if (!("is null".equals(op) || "is not null".equals(op) || "var is null".equals(op) || "var is not null".equals(op))) {
            if (value == null) {
                return this;
            }
            boolean bok = false;
            for (Object ob : value) {
                if (ob == null) continue;
                bok = true;
            }
            if (!bok) {
                ++this.clausePosition;
                return this;
            }
        }
        if ("between".equals(op)) {
            value = value != null && value.length == 0 ? null : value;
            Object begin = value == null ? null : value[0];
            Object end = value == null || value.length == 1 ? null : value[1];
            this.addClause(name, ">=", begin);
            this.addClause(name, "<", end);
        } else {
            this.addClause(new Clause(name, op, this.clauseConjuction, value));
        }
        return this;
    }

    private Object[] preHandleValue(Object ... value) {
        String s2;
        if (value != null && value.length == 1 && value[0] instanceof String && (s2 = (String)value[0]) != null && s2.length() == 0) {
            value = null;
        }
        return value;
    }

    public MpaasQuery addRowIdClause(String name, String op, String value) {
        return this.addClause(name, op, this.decryptRowId(value, String.class));
    }

    public MpaasQuery rowid(String field, String rowid) {
        return this.rowid(field, rowid, true);
    }

    public MpaasQuery rowid(String field, String rowid, boolean decrypt) {
        this.rowid = rowid;
        if (decrypt) {
            return this.addClause(field, "=", this.decryptRowId(rowid, String.class));
        }
        return this.addClause(field, "=", rowid);
    }

    public MpaasQuery rowid(String rowid) {
        this.rowid = rowid;
        return this.rowid("id", rowid, false);
    }

    public MpaasQuery sql(String sql) {
        this.sql = sql;
        return this;
    }

    public MpaasQuery table(String table) {
        this.table = table;
        return this;
    }

    public MpaasQuery view(String viewName) {
        this.viewName = viewName;
        return this;
    }

    public MpaasQuery viewQueryMode(boolean enable) {
        this.viewQueryMode = enable;
        return this;
    }

    public MpaasQuery countSql(String sql) {
        this.countSQL = sql;
        return this;
    }

    public MpaasQuery page(Integer page) {
        this.page = page;
        return this;
    }

    public MpaasQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MpaasQuery update(String field, Object value) {
        this.fullUpdate = false;
        return this.update(field, value, null);
    }

    private void update(Clause clause) {
        if (clause.getTag() != null) {
            this.update(clause.getField(), null, clause.getTag());
        } else {
            this.update(clause.getField(), clause.getValue(), null);
        }
    }

    private MpaasQuery update(String field, Object value, Object tag) {
        int index = 0;
        Clause clause = new Clause(field, value);
        clause.setTag(tag);
        for (Clause c2 : this.updateField) {
            if (c2.getField() == null || !c2.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        this.updateField.add(clause);
        return this;
    }

    public MpaasQuery update(String[] fields) {
        this.updateFieldNames = fields;
        this.fullUpdate = false;
        return this;
    }

    public MpaasQuery update(List<String> fields) {
        return this.update(fields.toArray(new String[fields.size()]));
    }

    public MpaasQuery version(Integer rowVersion) {
        this.rowVersion = rowVersion;
        return this;
    }

    public MpaasQuery bind(Object pojo) {
        if (pojo instanceof Class) {
            return this.bind((Class)pojo);
        }
        this.pojo = pojo;
        return this.bind(this.pojo.getClass());
    }

    public MpaasQuery bind(Class pojoClazz) {
        if (TypeUtil.isBasicType(pojoClazz)) {
            return this;
        }
        this.pojoClazz = pojoClazz;
        PojoMeta pm = this.getPojoMetaInfo();
        if (this.table == null) {
            this.table = pm.getTableName();
        }
        if (this.upper2Underline == null) {
            this.upper2Underline = pm.getUpper2Underline();
        }
        return this;
    }

    private PojoMeta getPojoMetaInfo() {
        if (this.pojoClazz == null) {
            return null;
        }
        if (this.pojoInfo != null) {
            return this.pojoInfo;
        }
        this.pojoInfo = this.pojo != null && this.pojo instanceof RowData ? new PojoMeta(this.pojo) : (PojoMeta)Cache.cache().get(this.pojoClazz.getName(), this.pojoClazz);
        return this.pojoInfo;
    }

    private void addClause(Clause clause) {
        if (this.clauses == null) {
            this.clauses = new ArrayList<Clause>();
        }
        int index = 0;
        for (Clause c2 : this.clauses) {
            if (!c2.getField().equals(clause.getField())) continue;
            ++index;
        }
        if (index > 0) {
            clause.setVariable(clause.getVariable() + "_" + index);
        }
        clause.setPosition(this.clausePosition++);
        this.clauses.add(clause);
    }

    public <T> List<T> doQuery(Class<T> result) {
        this.bind(result);
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        List<T> rs = this.postQuery(this.dbAdapter.executeQuery(this.buildQueryInfo(), query, parameters, result));
        this.clear();
        return rs;
    }

    public List<Map<String, Object>> doQuery() {
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        List<Map<String, Object>> rs = this.dbAdapter.executeQueryAsList(this.buildQueryInfo(), query, parameters);
        this.clear();
        return rs;
    }

    public <T> T doQueryFirst(Class<T> result) {
        List<T> rs = this.doQuery(result);
        if (rs == null || rs.size() == 0) {
            return null;
        }
        return rs.get(0);
    }

    public Map<String, Object> doQueryFirst() {
        List<Map<String, Object>> rs = this.doQuery();
        if (rs == null || rs.size() == 0) {
            return null;
        }
        return rs.get(0);
    }

    public PageQueryResult doPageQuery() {
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize);
    }

    public PageQueryResult doPageQuery(Integer page, Integer pageSize) {
        this.pageSize = pageSize;
        this.page = page;
        if (this.pojoClazz != null) {
            return this.doPageQuery(this.page, this.pageSize, this.pojoClazz);
        }
        String query = this.buildQuerySql(this.page, this.pageSize);
        PageQueryResult<Map<String, Object>> pageQueryResult = new PageQueryResult<Map<String, Object>>();
        pageQueryResult.setResult(this.dbAdapter.executeQueryAsList(this.buildQueryInfo(), query, this.buildParameter()));
        this.params.clear();
        for (ConjunctionPosition p2 : this.groupConIndex) {
            p2.setHit(false);
        }
        String sql = this.buildCountSql();
        QueryInfo q2 = this.buildQueryInfo();
        q2.setTag("count");
        List<Long> count = this.dbAdapter.executeQuery(q2, sql, this.buildParameter(), Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.clear();
        return pageQueryResult;
    }

    public <T> PageQueryResult<T> doPageQuery(Class<T> result) {
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Class<T> result) {
        this.page = page;
        return this.doPageQuery(this.page, this.pageSize, result);
    }

    public <T> PageQueryResult<T> doPageQuery(Integer page, Integer pageSize, Class<T> result) {
        this.bind(result);
        this.pageSize = pageSize;
        this.page = page;
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildQuerySql(this.page, this.pageSize);
            parameters = this.buildParameter();
        }
        PageQueryResult<T> pageQueryResult = new PageQueryResult<T>();
        pageQueryResult.setResult(this.postQuery(this.dbAdapter.executeQuery(this.buildQueryInfo(), query, parameters, result)));
        this.params.clear();
        for (ConjunctionPosition p2 : this.groupConIndex) {
            p2.setHit(false);
        }
        String cntSql = null;
        if (this.isSqlDatabase().booleanValue()) {
            cntSql = this.buildCountSql();
            parameters = this.buildParameter();
        }
        QueryInfo q2 = this.buildQueryInfo();
        q2.setTag("count");
        List<Long> count = this.dbAdapter.executeQuery(q2, cntSql, parameters, Long.class);
        if (count != null && count.size() > 0) {
            pageQueryResult.setCount(count.get(0));
        }
        this.clear();
        return pageQueryResult;
    }

    public void doDelete() {
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildDeleteSql();
            parameters = this.buildParameter();
        }
        this.dbAdapter.executeDelete(this.buildQueryInfo(), query, parameters);
        this.clear();
    }

    public void doDelete(Object pojo) {
        this.bind(pojo);
        this.doDelete();
    }

    public void doUpdate(Object pojo) {
        this.bind(pojo);
        this.doUpdate();
    }

    public void doUpdate() {
        boolean valid = false;
        if (this.clauses.size() == 0) {
            if (this.pojo != null) {
                PojoField idField = this.getRowIdField();
                if (this.pojo instanceof BasePojo && ((BasePojo)this.pojo).pojoId() != null) {
                    this.rowid(idField.getField().getName(), (String)((BasePojo)this.pojo).pojoId());
                    valid = true;
                }
                Object value = idField.getValue(this.pojo);
                if (!valid && idField != null && value != null) {
                    this.eq(idField.getFieldName(), value);
                    valid = true;
                }
            }
            if (!valid) {
                throw MpaasRuntimeException.fromCode("SW-180227", new Object[0]);
            }
        }
        if (this.pojo != null) {
            PojoMeta pm = this.getPojoMetaInfo();
            List<Clause> cls = pm.updateActionInit(this.pojo, this.getUpdateFieldNames());
            this.updateField.clear();
            for (Clause c2 : cls) {
                this.update(c2);
            }
        }
        String query = null;
        List<Parameter> parameters = null;
        if (this.isSqlDatabase().booleanValue()) {
            query = this.buildUpdateSql();
            parameters = this.buildParameter();
        }
        this.dbAdapter.executeUpdate(this.buildQueryInfo(), query, parameters);
        this.clear();
    }

    public Object doInsert() {
        PojoMeta pm = this.getPojoMetaInfo();
        this.pojo = pm.insertActionInit(this.pojo);
        String sql = this.buildInsertSql();
        PojoField rowIdField = this.getRowIdField();
        String rowIdName = rowIdField == null ? null : rowIdField.getSqlColumnName(this.upper2Underline);
        Object key = this.dbAdapter.executeInsert(this.buildQueryInfo(), sql, this.buildParameter(), rowIdName);
        if (key != null && rowIdField != null && rowIdField.getValue(this.pojo) == null) {
            try {
                rowIdField.setValue(this.pojo, TypeUtil.convert(key, rowIdField.getField().getType()));
                if (this.pojo instanceof MpaasBasePojo) {
                    ((MpaasBasePojo)this.pojo).encryptRowId(this.getRowIdSecret());
                }
            }
            catch (Throwable ex) {
                this.logger.warn(ex.getMessage(), new Object[0]);
            }
        }
        this.clear();
        if (key == null && rowIdField != null) {
            key = rowIdField.getValue(this.pojo);
        }
        return key;
    }

    public Object doInsert(Object pojo) {
        this.bind(pojo);
        return this.doInsert();
    }

    public MpaasQuery doExport(HttpServletResponse response, Class pojo) {
        if (this.excelFileName == null) {
            this.excelFileName = "excel.xlsx";
        }
        if (!this.excelFileName.endsWith(".xlsx")) {
            this.excelFileName = this.excelFileName + ".xlsx";
        }
        response.setContentType("application/octet-stream");
        try {
            String f2 = new String(this.excelFileName.getBytes("UTF-8"), "ISO8859_1");
            response.setHeader("Content-Disposition", "attachment;filename=" + f2);
            this.doExport((OutputStream)response.getOutputStream(), pojo);
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException(ex);
        }
        return this;
    }

    public MpaasQuery doExport(OutputStream os, Class pojo) {
        this.bind(pojo);
        PojoMeta pm = this.getPojoMetaInfo();
        MpaasExcel me = new MpaasExcel(os, pm, this.includeFields, this.excludeFields);
        int currentPage = 1;
        String tmp = this.sql;
        while (true) {
            this.pageSize = 100;
            this.page = currentPage;
            String query = this.buildQuerySql(this.page, this.pageSize);
            List<Object> result = this.dbAdapter.executeQuery(this.buildQueryInfo(), query, this.buildParameter(), pojo);
            if (result == null || result.size() == 0) break;
            me.export(result);
            ++currentPage;
            this.sql = tmp;
            this.viewConverted = false;
        }
        me.finish();
        this.clear();
        return this;
    }

    private String buildQuerySql(Integer page, Integer pageSize) {
        this.sql = this.buildSelectSql();
        String s2 = this.sql + " " + this.buildWhereClause();
        if (page == null || pageSize == null) {
            return s2;
        }
        return this.dialect.buildPageQuery(s2, page, pageSize);
    }

    public MpaasQuery orderBy(String field, String type) {
        this.orderby.add(new Parameter(field, type));
        return this;
    }

    public MpaasQuery groupBy(String field) {
        this.groupby = field;
        return this;
    }

    private String buildCountSql() {
        String s2;
        if (this.countSQL == null) {
            this.sql = this.buildSelectSql();
            s2 = this.sql + " " + this.buildWhereClause(false);
        } else {
            s2 = this.countSQL + " " + this.buildWhereClause(false);
        }
        s2 = String.format("select count(1)l from(%s)y", s2);
        return s2;
    }

    private String buildDeleteSql() {
        if (MpaasUtil.strEmpty(this.table)) {
            throw MpaasRuntimeException.fromCode("SW-180226", new Object[0]);
        }
        return String.format("delete from %s %s", this.table, this.buildWhereClause());
    }

    private String buildUpdateSql() {
        if (MpaasUtil.strEmpty(this.table)) {
            throw MpaasRuntimeException.fromCode("SW-180226", new Object[0]);
        }
        return String.format("update %s %s %s", this.table, this.buildUpdateSetClause(), this.buildWhereClause());
    }

    private String buildInsertSql() {
        if (this.pojo == null) {
            throw MpaasRuntimeException.fromCode("SW-180228", new Object[0]);
        }
        PojoMeta pm = this.getPojoMetaInfo();
        if (this.table == null) {
            this.table = pm.getTableName();
        }
        if (this.upper2Underline == null) {
            this.upper2Underline = pm.getUpper2Underline();
        }
        List<PojoField> fields = pm.getPojoFields();
        for (PojoField f2 : fields) {
            if (!f2.isDBColumn().booleanValue()) continue;
            String propertyName = f2.getSqlColumnName(this.upper2Underline);
            try {
                KeyValue keyValue = null;
                if (f2.isRowId().booleanValue()) {
                    keyValue = this.dialect.generateKey(this.table, propertyName, f2.getRowIDInfo());
                    if ("AUTOINCREMENT".equalsIgnoreCase(keyValue.getStyle())) continue;
                    if ("VALUE".equals(keyValue.getStyle())) {
                        f2.setValue(this.pojo, keyValue.getValue());
                    }
                }
                Object value = f2.getValue(this.pojo);
                Clause cl = new Clause(propertyName, null, this.clauseConjuction, value);
                if (keyValue != null) {
                    cl.setTag(keyValue);
                }
                this.clauses.add(cl);
            }
            catch (Exception e2) {
                throw new MpaasRuntimeException(e2);
            }
        }
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        String varFormat = this.getVariableFormat();
        for (Clause c2 : this.clauses) {
            KeyValue kv;
            Object tag = c2.getTag();
            if (tag != null && tag instanceof KeyValue && "AUTOINCREMENT".equalsIgnoreCase((kv = (KeyValue)tag).getStyle()) || c2.getValue() == null && !(tag instanceof KeyValue)) continue;
            if (s1.length() > 0) {
                s1.append(",");
                s2.append(",");
            }
            if (tag != null && tag instanceof KeyValue) {
                kv = (KeyValue)tag;
                if ("SEQUENCE".equalsIgnoreCase(kv.getStyle())) {
                    s1.append(c2.getField());
                    s2.append(kv.getValue());
                    continue;
                }
                if ("VALUE".equalsIgnoreCase(kv.getStyle())) {
                    s1.append(c2.getField());
                    s2.append(String.format(varFormat, c2.getVariable()));
                    this.params.add(new Parameter(c2.getVariable(), kv.getValue()));
                    continue;
                }
                if ("SQL".equalsIgnoreCase(kv.getStyle())) {
                    List rs = this.dbAdapter.executeQuery(this.buildQueryInfo(), (String)kv.getValue(), null, (Class)kv.getTag());
                    s1.append(c2.getField());
                    s2.append(String.format(varFormat, c2.getVariable()));
                    this.params.add(new Parameter(c2.getVariable(), rs.get(0)));
                    PojoField f3 = pm.findPojoField(c2.getField());
                    if (f3.getField() == null) {
                        f3.setValue(this.pojo, rs.get(0));
                        continue;
                    }
                    f3.setValue(this.pojo, TypeUtil.convert(rs.get(0), f3.getField().getType()));
                    continue;
                }
            }
            s1.append(c2.getField());
            s2.append(String.format(varFormat, c2.getVariable()));
            this.params.add(new Parameter(c2.getVariable(), c2.getValue()));
        }
        String sql = String.format("insert into %s(%s)values(%s)", this.table, s1.toString(), s2.toString());
        return sql;
    }

    private PojoField getRowIdField() {
        PojoMeta pm = this.getPojoMetaInfo();
        List<PojoField> fields = pm.getPojoFields();
        for (PojoField f2 : fields) {
            if (!f2.isRowId().booleanValue()) continue;
            return f2;
        }
        return null;
    }

    private void clear() {
        this.params.clear();
        this.updateField.clear();
        this.orderby.clear();
        this.clauses.clear();
        this.upper2Underline = null;
        this.clauseConjuction = "and";
        this.groupConIndex.clear();
        this.variables.clear();
        if (this.includeFields != null) {
            this.includeFields.clear();
        }
        if (this.excludeFields != null) {
            this.excludeFields.clear();
        }
        if (this.selectFields != null) {
            this.selectFields.clear();
        }
        this.updateFieldNames = null;
        this.viewQueryMode = false;
        this.viewName = null;
        this.viewConverted = false;
        this.clausePosition = 0;
        this.page = null;
        this.fullUpdate = true;
    }

    private String buildUpdateSetClause() {
        StringBuffer sb = new StringBuffer();
        String varFormat = this.getVariableFormat();
        for (Clause c2 : this.updateField) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                sb.append("set ");
            }
            if (c2.getTag() == null) {
                this.params.add(new Parameter(c2.getVariable(), c2.getValue()));
                sb.append(String.format("%s=" + varFormat, c2.getField(), c2.getVariable()));
                continue;
            }
            sb.append(c2.getTag().toString());
        }
        return sb.toString();
    }

    private String buildWhereClause() {
        return this.buildWhereClause(true);
    }

    private String buildWhereClause(boolean appendOrder) {
        StringBuffer sb = new StringBuffer();
        PojoMeta pm = this.getPojoMetaInfo();
        for (int i2 = 0; i2 < this.clauses.size(); ++i2) {
            Clause c2 = this.clauses.get(i2);
            if (pm != null) {
                c2.setField(pm.getFieldDBName(c2.getField()));
            } else {
                c2.setField(c2.getField());
            }
            c2.setVariableFormat(this.getVariableFormat());
            ClauseSQL cs = this.dialect.handleClause(c2);
            if (ClauseSQL.NONE.equals(cs.getType())) continue;
            if (ClauseSQL.VARIABLE.equals(cs.getType())) {
                this.params.add(new Parameter(c2.getVariable(), c2.getValue()));
            }
            String sql = cs.getSqlClause();
            if (sb.length() == 0) {
                sb.append("where (");
            }
            sb.append(this.calculateConjunction(c2.getPosition()));
            if (i2 > 0) {
                sb.append(" " + c2.getConjunction() + " ");
            }
            sb.append(sql);
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        if (this.groupby != null) {
            sb.append(" group by " + this.groupby + " ");
        }
        boolean flag = true;
        if (appendOrder) {
            for (Parameter p2 : this.orderby) {
                if (flag) {
                    sb.append(" order by ");
                } else {
                    sb.append(",");
                }
                flag = false;
                if (pm != null) {
                    sb.append(String.format("%s %s", pm.getFieldDBName(p2.getName()), p2.getValue()));
                    continue;
                }
                sb.append(String.format("%s %s", p2.getName(), p2.getValue()));
            }
        }
        return this.buildWhereClausePost(sb.toString());
    }

    private List<Parameter> buildParameter() {
        if (this.params.size() == 0) {
            this.buildWhereClause();
        }
        ArrayList<Parameter> result = null;
        for (Clause c2 : this.variables) {
            if (result == null) {
                result = new ArrayList<Parameter>();
            }
            result.add(new Parameter(c2.getVariable(), c2.getValue()));
        }
        if (result == null) {
            return this.params;
        }
        result.addAll(this.params);
        return result;
    }

    public MpaasQuery or() {
        this.clauseConjuction = "or";
        return this;
    }

    public MpaasQuery and() {
        this.clauseConjuction = "and";
        return this;
    }

    public MpaasQuery conjuctionAnd() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "and"));
        return this;
    }

    public MpaasQuery groupBegin() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "("));
        return this;
    }

    public MpaasQuery groupEnd() {
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), ")"));
        return this;
    }

    public MpaasQuery conjuctionOr() {
        if (this.clauses.isEmpty()) {
            return this;
        }
        this.groupConIndex.add(new ConjunctionPosition(this.clausePosition, this.clauses.size(), "or"));
        return this;
    }

    public MpaasQuery fileName(String excelFileName) {
        this.excelFileName = excelFileName;
        return this;
    }

    private String calculateConjunction(Integer position) {
        String result = "";
        for (int i2 = 0; i2 < this.groupConIndex.size(); ++i2) {
            ConjunctionPosition p2 = this.groupConIndex.get(i2);
            if (p2.getPos() != position.intValue() || p2.isHit() || !p2.isConjunction()) continue;
            if (p2.getPos() > position) break;
            p2.setHit(true);
            result = ")" + p2.getConjunction() + "(";
        }
        boolean hit = false;
        for (int i3 = 0; i3 < this.groupConIndex.size(); ++i3) {
            ConjunctionPosition p3 = this.groupConIndex.get(i3);
            if (p3.getPos() != position.intValue() || p3.isHit() || p3.isConjunction()) {
                if (!"LEFT".equals(p3.getType())) continue;
                hit = p3.isHit();
                continue;
            }
            if (p3.getPos() > position) break;
            p3.setHit(true);
            if ("LEFT".equals(p3.getType())) {
                result = result + "(";
                continue;
            }
            if (!hit) continue;
            result = ")" + result;
        }
        return result;
    }

    private boolean isEnd() {
        if (this.groupConIndex.size() == 0) {
            return true;
        }
        ConjunctionPosition con = this.groupConIndex.get(this.groupConIndex.size() - 1);
        if ("RIGHT".equals(con.getType()) && !con.isHit()) {
            for (int i2 = this.groupConIndex.size() - 1; i2 >= 0; --i2) {
                ConjunctionPosition c2 = this.groupConIndex.get(i2);
                if (!"LEFT".equals(c2.getType()) || !c2.isHit()) continue;
                return false;
            }
        }
        return true;
    }

    private String buildWhereClausePost(String sql) {
        String v2 = sql.replaceAll("\\(\\s+or\\s+", "(");
        v2 = v2.replaceAll("\\(\\s+and\\s+", "(");
        v2 = v2.replaceAll("\\(\\s*\\)", " ");
        v2 = v2.replaceAll("^where\\s*or", "where ");
        v2 = v2.replaceAll("^where\\s*and", "where ");
        if (!this.isEnd()) {
            v2 = v2 + ")";
        }
        return v2;
    }

    private <T> List<T> postQuery(List<T> result) {
        if (result == null) {
            return result;
        }
        for (T item : result) {
            if (!(item instanceof MpaasBasePojo)) continue;
            ((MpaasBasePojo)item).encryptRowId(this.getRowIdSecret());
        }
        return result;
    }

    public Object decryptRowId(String content, Class clazz) {
        String s2 = MpaasQueryUtil.decryptRowId(content, this.getRowIdSecret());
        if (clazz == Integer.class) {
            return Integer.parseInt(s2);
        }
        if (clazz == Long.class) {
            return Long.parseLong(s2);
        }
        return s2;
    }

    public MpaasQuery include(String ... fields) {
        if (this.includeFields == null) {
            this.includeFields = new HashSet<String>();
        }
        for (String s2 : Arrays.asList(fields)) {
            this.includeFields.add(s2.toUpperCase());
        }
        return this;
    }

    public MpaasQuery exclude(String ... fields) {
        if (this.excludeFields == null) {
            this.excludeFields = new HashSet<String>();
        }
        for (String s2 : Arrays.asList(fields)) {
            this.excludeFields.add(s2.toUpperCase());
        }
        return this;
    }

    public MpaasQuery select(String ... fields) {
        Set<String> sf = this.getSelectFields();
        for (String s2 : Arrays.asList(fields)) {
            sf.add(s2);
        }
        return this;
    }

    public MpaasQuery unSelect(String ... fields) {
        Set<String> sf = this.getUnSelectFields();
        for (String s2 : Arrays.asList(fields)) {
            sf.add(s2.toLowerCase());
        }
        return this;
    }

    public MpaasQuery unSelect(String s2) {
        return this.unSelect(s2.split(","));
    }

    public MpaasQuery select(String s2) {
        return this.select(s2.split(","));
    }

    private String buildSqlBySelectFields() {
        if (this.buildFinalSelectFields().size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("select ");
        PojoMeta pm = this.getPojoMetaInfo();
        Assert.notNull((Object)this.table, (String)"table name is null");
        boolean flag = false;
        for (String s2 : this.getSelectFields()) {
            if (flag) {
                sb.append(",");
            }
            flag = true;
            if ("*".equals(s2)) {
                sb.append(s2);
                continue;
            }
            sb.append(pm == null ? s2 : pm.getFieldDBName(s2));
        }
        sb.append(" from");
        sb.append(" " + (this.viewQueryMode ? this.viewName : this.table));
        return sb.toString();
    }

    private Set<String> buildFinalSelectFields() {
        Set<String> sf = this.getSelectFields();
        PojoMeta pm = this.getPojoMetaInfo();
        if (sf.isEmpty()) {
            if (!this.viewQueryMode && pm != null) {
                for (PojoField f2 : pm.getDatabaseFields()) {
                    sf.add(f2.getSqlColumnName(this.upper2Underline));
                }
            } else {
                sf.add("*");
            }
        }
        if (!this.viewQueryMode) {
            for (String s2 : this.getUnSelectFields()) {
                PojoField f3 = pm.findPojoField(s2);
                if (f3 == null) {
                    throw new MpaasRuntimeException("can not find field %s", s2);
                }
                Iterator<String> iterator = sf.iterator();
                while (iterator.hasNext()) {
                    if (!f3.getSqlColumnName(this.upper2Underline).equalsIgnoreCase(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }
        return sf;
    }

    private Set<String> getSelectFields() {
        if (this.selectFields == null) {
            this.selectFields = new HashSet<String>();
        }
        return this.selectFields;
    }

    private Set<String> getUnSelectFields() {
        if (this.unSelectFields == null) {
            this.unSelectFields = new HashSet<String>();
        }
        return this.unSelectFields;
    }

    private String buildSelectSql() {
        if (MpaasUtil.strEmpty(this.sql)) {
            this.sql = this.buildSqlBySelectFields();
            if (MpaasUtil.strEmpty(this.sql) && this.viewQueryMode) {
                Assert.notNull((Object)this.viewName, (String)"view name is null");
                this.sql = this.getPojoMetaInfo().getSqlQuerys().get(this.viewName).sql();
                return this.sql;
            }
        }
        Assert.notNull((Object)this.sql, (String)"sql is null");
        this.sql = this.viewQuerySQLConvert(this.sql);
        this.sql = this.variableSQLConvert(this.sql);
        return this.sql;
    }

    private String viewQuerySQLConvert(String sql) {
        PojoMeta pm = this.getPojoMetaInfo();
        if (this.viewQueryMode && !this.viewConverted) {
            sql = SQLUtil.replaceWithQuerySQL(sql, pm.getSqlQuerys());
            this.viewConverted = true;
        }
        return sql;
    }

    private String variableSQLConvert(String sql) {
        for (Clause c2 : this.variables) {
            String s2 = String.format(this.getVariableFormat(), c2.getVariable());
            sql = sql.replaceAll("#" + c2.getField(), s2);
        }
        return sql;
    }

    public MpaasQuery like(String field, String value) {
        return this.addClause(field, "like", value);
    }

    public MpaasQuery notLike(String field, String value) {
        return this.addClause(field, "not like", value);
    }

    public MpaasQuery startWith(String field, String value) {
        return this.addClause(field, "^", value);
    }

    public MpaasQuery endWith(String field, String value) {
        return this.addClause(field, "$", value);
    }

    public MpaasQuery eq(String field, Object value) {
        return this.addClause(field, "=", value);
    }

    public MpaasQuery ne(String field, Object value) {
        return this.addClause(field, "!=", value);
    }

    public MpaasQuery lt(String field, Object value) {
        return this.addClause(field, "<", value);
    }

    public MpaasQuery gt(String field, Object value) {
        return this.addClause(field, ">", value);
    }

    public MpaasQuery lteq(String field, Object value) {
        return this.addClause(field, "<=", value);
    }

    public MpaasQuery gteq(String field, Object value) {
        return this.addClause(field, ">=", value);
    }

    public MpaasQuery isNull(String field) {
        return this.addClause(field, "is null", new Object[0]);
    }

    public MpaasQuery isNotNull(String field) {
        return this.addClause(field, "is not null", new Object[0]);
    }

    public MpaasQuery in(String field, Object ... values) {
        return this.addClause(field, "in", values);
    }

    public MpaasQuery in(String field, Collection values) {
        return this.addClause(field, "in", values.toArray());
    }

    public MpaasQuery notIn(String field, Object ... values) {
        return this.addClause(field, "not in", values);
    }

    public MpaasQuery notIn(String field, Collection values) {
        return this.addClause(field, "not in", values.toArray());
    }

    public MpaasQuery distinct(String fields) {
        this.distinct = fields;
        return this;
    }

    public Object callFunction(String funName, Object ... paramAndResult) {
        List<Object> result = this.dbAdapter.executeProcedure("FUNCTION", funName, paramAndResult);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<Object> callProcedure(String procName, Object ... paramAndResult) {
        return this.dbAdapter.executeProcedure("PROCEDURE", procName, paramAndResult);
    }

    public void doMerge(Object item) {
        this.bind(item);
        PojoField idField = this.getRowIdField();
        if (item instanceof BasePojo && ((BasePojo)item).pojoId() != null || idField != null && idField.getValue(item) != null) {
            this.doUpdate(item);
            return;
        }
        this.doInsert(item);
    }

    public MpaasQuery setVar(String name, Object value) {
        if (value == null) {
            throw new MpaasRuntimeException("variable %s is null", name);
        }
        Clause c2 = new Clause(name, value);
        c2.setVariable("va_" + name);
        this.variables.add(c2);
        return this;
    }

    private String[] getUpdateFieldNames() {
        if ((this.updateFieldNames == null || this.updateFieldNames.length == 0) && this.updateField != null && this.updateField.size() > 0) {
            this.updateFieldNames = new String[this.updateField.size()];
            for (int i2 = 0; i2 < this.updateFieldNames.length; ++i2) {
                this.updateFieldNames[i2] = this.updateField.get(i2).getField();
            }
        }
        return this.updateFieldNames;
    }

    private QueryInfo buildQueryInfo() {
        QueryInfo info = new QueryInfo();
        info.setTable(this.table);
        info.setClauses(this.clauses);
        info.setRowId(this.rowid);
        info.setPojoClazz(this.pojoClazz);
        info.setPojo(this.pojo);
        info.setOrderby(this.orderby);
        info.setPage(this.page);
        info.setPageSize(this.pageSize);
        info.setGroupConIndex(this.groupConIndex);
        info.setPojoMeta(this.getPojoMetaInfo());
        info.setDistinct(this.distinct);
        info.setUpdateField(this.updateField);
        info.setSelectFields(this.selectFields);
        info.setFullUpdate(this.fullUpdate);
        return info;
    }

    private Boolean isSqlDatabase() {
        return this.dbAdapter.isSqlDatabase();
    }

    private String getVariableFormat() {
        return this.dbAdapter.varformat();
    }

    private String getRowIdSecret() {
        return this.config.rowIdSecret;
    }
}

