/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.conf;

import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.sql2o.Sql2o;

@Configuration
public class DatabaseContext {
    @Autowired
    private MpaasQueryConfig config;

    @Bean
    public DataSource dataSource() {
        if (!"none".equalsIgnoreCase(this.config.dbJndi)) {
            JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
            bean.setJndiName(this.config.dbJndi);
            bean.setProxyInterface(DataSource.class);
            bean.setLookupOnStartup(false);
            try {
                bean.afterPropertiesSet();
            }
            catch (NamingException e2) {
                e2.printStackTrace();
            }
            return (DataSource)bean.getObject();
        }
        return null;
    }

    @Bean
    @Autowired
    public Sql2o sql2o(DataSource dataSource) {
        return new Sql2o(dataSource);
    }
}

