/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.Sql2ODatabaseAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseAdapterFactory {
    @Autowired(required=false)
    private Sql2ODatabaseAdapter sql2ODatabaseAdapter;
    @Autowired(required=false)
    private Sql2ODatabaseAdapter mybatisDatabaseAdapter;
    @Autowired
    private SWordLogger logger;
    @Autowired
    private MpaasQueryConfig config;

    public DatabaseAdapter buildDatabaseAdapter() {
        if ("sql2o".equalsIgnoreCase(this.config.DB_ADAPTER)) {
            return this.sql2ODatabaseAdapter;
        }
        if ("mybatis".equalsIgnoreCase(this.config.DB_ADAPTER)) {
            return this.mybatisDatabaseAdapter;
        }
        if ("nosql".equalsIgnoreCase(this.config.DB_ADAPTER)) {
            // empty if block
        }
        return this.sql2ODatabaseAdapter;
    }

    public DatabaseAdapter buildMultiDatasourceAdapter(String type) {
        if ("sql2o".equalsIgnoreCase(type) || "sql".equalsIgnoreCase(type) || "oracle".equalsIgnoreCase(type) || "mysql".equalsIgnoreCase(type)) {
            return new Sql2ODatabaseAdapter().logger(this.logger);
        }
        if ("mongodb".equalsIgnoreCase(type) || "nosql".equalsIgnoreCase(type)) {
            // empty if block
        }
        return new Sql2ODatabaseAdapter().logger(this.logger);
    }
}

