/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.Clause;
import com.definesys.mpaas.query.annotation.RowIDType;
import com.definesys.mpaas.query.db.ClauseSQL;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.KeyValue;
import com.definesys.mpaas.query.db.RowIDInfo;

public class OracleDialect
implements Dialect {
    public static final String PAGE_SQL_TEMPLATE = "select * from(select t.*,rownum rn from(%s)t where rownum<%d) where rn>=%d";

    @Override
    public ClauseSQL handleClause(Clause clause) {
        ClauseSQL cl = new ClauseSQL(ClauseSQL.VARIABLE);
        if (!("is null".equals(clause.getOp()) || "is not null".equals(clause.getOp()) || "var is null".equals(clause.getOp()) || "var is not null".equals(clause.getOp()) || clause != null && clause.getValues() != null && clause.getValues().get(0) != null)) {
            cl.setType(ClauseSQL.NONE);
            return cl;
        }
        String sql = null;
        String op = clause.getOp();
        String fmt = clause.getVariableFormat();
        if (fmt == null) {
            fmt = ":%s";
        }
        String var = String.format(fmt, clause.getVariable());
        if ("like".equals(op)) {
            sql = String.format("instr(%s,%s)>0", clause.getField(), var);
        } else if ("=".equals(op)) {
            sql = String.format("%s = %s", clause.getField(), var);
        } else if ("!=".equals(op)) {
            sql = String.format("%s <> %s", clause.getField(), var);
        } else if (">".equals(op)) {
            sql = String.format("%s > %s", clause.getField(), var);
        } else if (">=".equals(op)) {
            sql = String.format("%s >= %s", clause.getField(), var);
        } else if ("<".equals(op)) {
            sql = String.format("%s < %s", clause.getField(), var);
        } else if ("<=".equals(op)) {
            sql = String.format("%s <= %s", clause.getField(), var);
        } else if ("^".equals(op)) {
            sql = String.format("%s like CONCAT('',concat(%s,'%%'))", clause.getField(), var);
        } else if ("$".equals(op)) {
            sql = String.format("%s like CONCAT('%%',concat(%s,''))", clause.getField(), var);
        } else if ("is null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is null", clause.getField());
        } else if ("is not null".equals(op)) {
            cl.setType(ClauseSQL.PURE);
            sql = String.format("%s is not null", clause.getField());
        } else if ("var is null".equals(op)) {
            sql = String.format("%s is null", clause.getVariable());
        } else if ("var is not null".equals(op)) {
            sql = String.format("%s is not null", clause.getVariable());
        } else if ("not like".equals(op)) {
            sql = String.format("instr(%s,%s)=0", clause.getField(), var);
        } else if ("in".equals(op) || "not in".equals(op)) {
            String s2;
            StringBuffer sb = new StringBuffer();
            cl.setType(ClauseSQL.PURE);
            for (Object v2 : clause.getValues()) {
                if (v2 instanceof Iterable) {
                    for (Object v1 : (Iterable)v2) {
                        if (v1 == null) continue;
                        this.append(sb, v1);
                    }
                    continue;
                }
                if (v2 == null) continue;
                this.append(sb, v2);
            }
            String string = s2 = "in".equals(op) ? "in" : "not in";
            sql = sb.length() == 0 ? "1=1" : String.format("%s %s(%s)", clause.getField(), s2, sb.toString());
        } else if ("between".equals(op)) {
            sql = String.format("%s between :%s_begin and :%s_end", clause.getField(), clause.getVariable(), clause.getVariable());
        }
        cl.setSqlClause(sql);
        return cl;
    }

    private void append(StringBuffer sb, Object v2) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        if (v2 instanceof String) {
            sb.append("'");
            sb.append(v2);
            sb.append("'");
        } else {
            sb.append(v2);
        }
    }

    @Override
    public String buildPageQuery(String sql, Integer page, Integer pageSize) {
        if (page == null || pageSize == null) {
            return sql;
        }
        int begin = (page - 1) * pageSize + 1;
        int end = begin + pageSize;
        return String.format(PAGE_SQL_TEMPLATE, sql, end, begin);
    }

    @Override
    public KeyValue generateKey(String tableName, String column, RowIDInfo rowID) {
        RowIDType rowIDType = rowID.getType();
        KeyValue key = new KeyValue();
        if (rowIDType == RowIDType.SEQUENCE || rowIDType == RowIDType.AUTO) {
            String seq = rowID.getSequence();
            seq = MpaasUtil.strEmpty(seq) ? tableName + "_s.nextval" : seq + ".nextval";
            key.setStyle("SEQUENCE");
            key.setValue(seq);
            String sql = String.format("select %s from dual", seq);
            key.setStyle("SQL");
            key.setValue(sql);
            key.setTag(Long.class);
        } else if (rowIDType == RowIDType.UUID) {
            key.setStyle("VALUE");
            key.setValue(MpaasUtil.generateUniqueKey());
        } else {
            throw new MpaasRuntimeException("unsupport RowIDType:" + (Object)((Object)rowID.getType()));
        }
        return key;
    }
}

