/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.db;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.Clause;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DefaultDatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.db.StorageDatasource;
import com.definesys.mpaas.query.model.QueryInfo;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.sql2o.Connection;
import org.sql2o.Query;
import org.sql2o.Sql2o;

@Component
public class Sql2ODatabaseAdapter
extends DefaultDatabaseAdapter {
    @Autowired(required=false)
    private Sql2o sql2o;
    @Autowired(required=false)
    private SWordLogger logger;
    private DataSource dataSource;

    @Override
    public <T> List<T> executeQuery(QueryInfo queryInfo, String sql, List<Parameter> prames, Class<T> result) {
        try (Connection conn = this.getConnection();){
            this.logger.debug("executeQuery sql==>%s", sql);
            Query query = conn.createQuery(sql, false);
            if (prames != null) {
                for (Parameter p2 : prames) {
                    query.addParameter(p2.getName(), p2.getValue());
                }
            }
            List<T> list = query.executeAndFetch(result);
            return list;
        }
    }

    @Override
    public List<Map<String, Object>> executeQueryAsList(QueryInfo queryInfo, String sql, List<Parameter> prames) {
        try (Connection conn = this.getConnection();){
            this.logger.debug("executeQueryAsList sql==>%s", sql);
            Query query = conn.createQuery(sql, false);
            for (Parameter p2 : prames) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            List<Map<String, Object>> list = query.executeAndFetchTable().asList();
            return list;
        }
    }

    @Override
    public int executeDelete(QueryInfo queryInfo, String sql, List<Parameter> params) {
        List<Clause> clauses;
        this.logger.debug("executeDelete sql==>%s", sql);
        if (!(params != null && params.size() != 0 || (clauses = queryInfo.getClauses()) != null && clauses.size() != 0 && "in".equals(clauses.get(0).getOp()))) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
        return this.executeUpdate(queryInfo, sql, params);
    }

    @Override
    public int executeUpdate(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.logger.debug("executeUpdate sql==>%s", sql);
        try (Connection conn = this.getConnection();){
            this.logger.info(sql, new Object[0]);
            conn.getJdbcConnection().setAutoCommit(false);
            Query query = conn.createQuery(sql, false);
            for (Parameter p2 : params) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            int result = query.executeUpdate().getResult();
            conn.commit();
            int n2 = result;
            return n2;
        }
    }

    @Override
    public Object executeInsert(QueryInfo queryInfo, String sql, List<Parameter> params, String ... keyColumns) {
        this.logger.debug("executeInsert sql==>%s", sql);
        Connection conn = this.getConnection();
        if (keyColumns == null) {
            keyColumns = new String[]{};
        }
        Object key = null;
        try {
            this.logger.info(sql, new Object[0]);
            conn.getJdbcConnection().setAutoCommit(false);
            Query query = conn.createQuery(sql, keyColumns);
            for (Parameter p2 : params) {
                query.addParameter(p2.getName(), p2.getValue());
            }
            if (keyColumns != null) {
                key = query.executeUpdate().getKey();
            }
            conn.commit();
            Object object = key;
            return object;
        }
        catch (Exception e2) {
            conn.rollback();
            throw new MpaasRuntimeException(e2);
        }
        finally {
            conn.close();
        }
    }

    private Connection getConnection() {
        if (this.dataSource == null) {
            return this.sql2o.open();
        }
        return new Sql2o(this.dataSource).open();
    }

    @Override
    public void dataSource(StorageDatasource dataSource) {
        this.dataSource = (DataSource)dataSource.getDatasource();
    }

    public DatabaseAdapter logger(SWordLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public Boolean isSqlDatabase() {
        return true;
    }

    @Override
    public String varformat() {
        return ":%s";
    }
}

