/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.excel;

import com.definesys.mpaas.cache.PojoField;
import com.definesys.mpaas.cache.PojoMeta;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.annotation.Style;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;

public class MpaasExcel<T> {
    private Workbook wb;
    private Worksheet ws;
    private PojoMeta pojo;
    private boolean titleExported = false;
    private Set<String> exclude;
    private Set<String> include;

    public MpaasExcel(OutputStream os, PojoMeta pojo, Set<String> include, Set<String> exclude) {
        this.wb = new Workbook(os, "MpassExcelExport");
        this.ws = this.wb.newWorksheet("Sheet 1");
        this.pojo = pojo;
        this.exclude = exclude;
        this.include = include;
    }

    public void export(List<Object> data) {
        if (!this.titleExported) {
            this.titleExported = true;
            this.exportTitle();
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Object item = data.get(i2);
            List<PojoField> fields = this.pojo.getPojoFields();
            int c2 = 0;
            for (PojoField f2 : fields) {
                if (!this.isCanExport(f2)) continue;
                this.ws.value(i2, c2++, f2.getFormatValue(item));
            }
        }
        try {
            this.ws.flush();
        }
        catch (IOException e2) {
            throw new MpaasRuntimeException(e2);
        }
    }

    public void finish() {
        try {
            if (!this.titleExported) {
                this.titleExported = true;
                this.export(new ArrayList<Object>());
            }
            this.wb.finish();
        }
        catch (IOException e2) {
            throw new MpaasRuntimeException(e2);
        }
    }

    private void exportTitle() {
        int i2 = 0;
        for (PojoField f2 : this.pojo.getPojoFields()) {
            String w2;
            if (!this.isCanExport(f2)) continue;
            this.ws.style(0, i2).bold().set();
            this.ws.value(0, i2, f2.getDisplayName());
            Style s2 = f2.getStyle();
            if (s2 != null && (w2 = s2.width()) != null && w2.trim().length() > 0) {
                try {
                    Double dw = Double.parseDouble(w2);
                    this.ws.width(i2, dw);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i2;
        }
        try {
            this.ws.flush();
        }
        catch (IOException e2) {
            throw new MpaasRuntimeException(e2);
        }
    }

    private boolean isCanExport(PojoField field) {
        boolean ok = true;
        String name = field.getField().getName().toUpperCase();
        String dbName = field.getSqlColumnName(this.pojo.getUpper2Underline()).toUpperCase();
        if (this.exclude != null && (this.exclude.contains(name) || this.exclude.contains(dbName))) {
            ok = false;
        }
        if (this.include != null) {
            ok = this.include.contains(name) || this.include.contains(dbName);
        }
        return ok;
    }
}

