/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.oracle;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProcedureExecutor {
    private Connection connection;

    public ProcedureExecutor(Connection connection) {
        this.connection = connection;
    }

    public List<Object> call(String funOrProc, String name, Object[] paramAndResult) {
        ArrayList<Object> ps = new ArrayList<Object>();
        ArrayList<Class> clazz = new ArrayList<Class>();
        List<Object> result = new ArrayList<Object>();
        StringBuffer clobIndexStr = new StringBuffer();
        int clobIndex = 1;
        if (paramAndResult != null) {
            for (Object p2 : paramAndResult) {
                if (p2 instanceof Class) {
                    clazz.add((Class)p2);
                    if (p2 != byte[].class) continue;
                    if (clobIndexStr.length() > 0) {
                        clobIndexStr.append(",");
                    }
                    clobIndexStr.append(clobIndex++);
                    continue;
                }
                ps.add(p2);
                ++clobIndex;
            }
        }
        if ("FUNCTION".equalsIgnoreCase(funOrProc)) {
            Class c2 = clazz.size() == 0 ? String.class : (Class)clazz.get(0);
            result.add(this.transform(this.invokeFunction(name, clobIndex > 1, ps.toArray()), c2));
        } else if ("PROCEDURE".equalsIgnoreCase(funOrProc)) {
            result = this.callStoreProcedure(name, clazz.size(), clobIndexStr.length() == 0 ? null : clobIndexStr.toString(), ps.toArray());
            for (int i2 = 0; i2 < result.size(); ++i2) {
                result.set(i2, this.transform((String)result.get(i2), (Class)clazz.get(i2)));
            }
        }
        return result;
    }

    private String invokeFunction(String stmt, boolean clob, Object ... inParams) throws MpaasRuntimeException {
        CallableStatement st = null;
        String result = null;
        int size = inParams == null ? 0 : inParams.length;
        stmt = this.convertStmtWithParams(stmt, size);
        try {
            st = this.connection.prepareCall("{call ?:= " + stmt + "}");
            int i2 = 2;
            if (inParams != null && inParams.length > 0) {
                for (Object item : inParams) {
                    st.setObject(i2, item);
                    ++i2;
                }
            }
            st.registerOutParameter(1, clob ? 2005 : 12);
            st.execute();
            if (!clob) {
                result = st.getObject(1) == null ? "" : st.getObject(1).toString();
            } else {
                Clob cl = st.getClob(1);
                if (cl != null) {
                    result = cl.getSubString(1L, (int)cl.length());
                }
            }
            this.close(null, st, null);
        }
        catch (Exception e2) {
            try {
                e2.printStackTrace();
                throw new MpaasRuntimeException(String.format("execute function %s faield:%s", stmt, e2.getMessage()));
            }
            catch (Throwable throwable) {
                this.close(null, st, null);
                throw throwable;
            }
        }
        return result;
    }

    private List<Object> callStoreProcedure(String stmt, int outParamsCount, String clobIndex, Object ... inParams) throws MpaasRuntimeException {
        ArrayList<Object> outParams = new ArrayList<Object>();
        CallableStatement st = null;
        int size = inParams == null ? 0 : inParams.length;
        size = outParamsCount + size;
        stmt = this.convertStmtWithParams(stmt, size);
        boolean[] clobFlag = null;
        if (clobIndex != null && inParams != null && inParams.length > 0) {
            clobFlag = new boolean[inParams.length + outParamsCount];
            for (int i2 = 0; i2 < clobFlag.length; ++i2) {
                clobFlag[i2] = false;
            }
            String[] strs = clobIndex.split(",");
            for (String s2 : strs) {
                int index = Integer.parseInt(s2);
                clobFlag[index - 1] = true;
            }
        }
        try {
            int j2;
            st = this.connection.prepareCall("begin " + stmt + "; end;");
            int i3 = 1;
            for (Object in : inParams) {
                st.setObject(i3, in);
                ++i3;
            }
            for (j2 = 0; j2 < outParamsCount; ++j2) {
                if (clobIndex != null && clobFlag[i3 + j2 - 1]) {
                    st.registerOutParameter(i3 + j2, 2005);
                    continue;
                }
                st.registerOutParameter(i3 + j2, 12);
            }
            st.executeUpdate();
            for (j2 = 0; j2 < outParamsCount; ++j2) {
                outParams.add(j2, st.getString(i3 + j2));
            }
            this.close(null, st, null);
        }
        catch (SQLException e2) {
            try {
                e2.printStackTrace();
                throw new MpaasRuntimeException(String.format("call procedure:%s failed:%s", stmt, e2.getMessage()));
            }
            catch (Throwable throwable) {
                this.close(null, st, null);
                throw throwable;
            }
        }
        return outParams;
    }

    private String convertStmtWithParams(String stmt, int paramCount) {
        StringBuffer buf = new StringBuffer(stmt);
        buf.append("(");
        for (int i2 = 0; i2 < paramCount; ++i2) {
            if (i2 != 0) {
                buf.append(",");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    private void close(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e3) {
                e3.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e4) {
                e4.printStackTrace();
            }
        }
    }

    private <T> T transform(String value, Class<T> t2) {
        T result = null;
        if (value == null || value.trim().length() == 0) {
            return result;
        }
        try {
            if (Long.class == t2) {
                result = (T)Class.forName("java.lang.Long").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Integer.class == t2) {
                result = (T)Class.forName("java.lang.Integer").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Double.class == t2) {
                result = (T)Class.forName("java.lang.Integer").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            } else if (Float.class == t2) {
                result = (T)Class.forName("java.lang.Float").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            }
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException("cant convert from %s to type:%s", value, t2.getName());
        }
        try {
            if (result == null) {
                result = (T)Class.forName("java.lang.String").getConstructor(Class.forName("java.lang.String")).newInstance(value);
            }
        }
        catch (Exception ex) {
            throw new MpaasRuntimeException("cant convert from %s to type:%s", value, t2.getName());
        }
        return result;
    }

    public void close() {
        this.close(this.connection, null, null);
    }
}

