/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

public class Base32Util {
    private static final char[] ALPHABET;
    private static final byte[] DECODE_TABLE;

    public static String encode(byte[] data) {
        char[] chars = new char[data.length * 8 / 5 + (data.length % 5 != 0 ? 1 : 0)];
        int j2 = 0;
        int index = 0;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (index > 3) {
                int b2 = data[j2] & 255 >> index;
                index = (index + 5) % 8;
                b2 <<= index;
                if (j2 < data.length - 1) {
                    b2 |= (data[j2 + 1] & 0xFF) >> 8 - index;
                }
                chars[i2] = ALPHABET[b2];
                ++j2;
                continue;
            }
            chars[i2] = ALPHABET[data[j2] >> 8 - (index + 5) & 0x1F];
            if ((index = (index + 5) % 8) != 0) continue;
            ++j2;
        }
        return new String(chars);
    }

    public static byte[] decode(String s2) throws Exception {
        char[] stringData = s2.toCharArray();
        byte[] data = new byte[stringData.length * 5 / 8];
        int j2 = 0;
        int index = 0;
        for (int i2 = 0; i2 < stringData.length; ++i2) {
            byte val;
            try {
                val = DECODE_TABLE[stringData[i2]];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new Exception("Illegal character");
            }
            if (val == 255) {
                throw new Exception("Illegal character");
            }
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n2 = j2++;
                    data[n2] = (byte)(data[n2] | val);
                    continue;
                }
                int n3 = j2;
                data[n3] = (byte)(data[n3] | val << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n4 = j2++;
            data[n4] = (byte)(data[n4] | val >> index);
            if (j2 >= data.length) continue;
            int n5 = j2;
            data[n5] = (byte)(data[n5] | val << 8 - index);
        }
        return data;
    }

    static {
        int i2;
        ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
        DECODE_TABLE = new byte[128];
        for (i2 = 0; i2 < DECODE_TABLE.length; ++i2) {
            Base32Util.DECODE_TABLE[i2] = -1;
        }
        for (i2 = 0; i2 < ALPHABET.length; ++i2) {
            Base32Util.DECODE_TABLE[Base32Util.ALPHABET[i2]] = (byte)i2;
            if (i2 >= 24) continue;
            Base32Util.DECODE_TABLE[Character.toLowerCase((char)Base32Util.ALPHABET[i2])] = (byte)i2;
        }
    }
}

