/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import org.dhatim.fastexcel.Writer;

class Alignment {
    private final String horizontal;
    private final String vertical;
    private final boolean wrapText;

    Alignment(String horizontal, String vertical, boolean wrapText) {
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.wrapText = wrapText;
    }

    public int hashCode() {
        return Objects.hash(this.horizontal, this.vertical, this.wrapText);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Alignment other = (Alignment)obj;
            result = Objects.equals(this.horizontal, other.horizontal) && Objects.equals(this.vertical, other.vertical) && Objects.equals(this.wrapText, other.wrapText);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w2) throws IOException {
        w2.append("<alignment");
        if (this.horizontal != null) {
            w2.append(" horizontal=\"").append(this.horizontal).append('\"');
        }
        if (this.vertical != null) {
            w2.append(" vertical=\"").append(this.vertical).append('\"');
        }
        if (this.wrapText) {
            w2.append(" wrapText=\"").append(Boolean.toString(this.wrapText)).append('\"');
        }
        w2.append("/>");
    }
}

