/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.dhatim.fastexcel.CachedString;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.TimestampUtil;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

class Cell {
    private Object value;
    private int style;

    Cell() {
    }

    void write(Writer w2, int r2, int c2) throws IOException {
        if (this.value != null || this.style != 0) {
            w2.append("<c r=\"").append(Range.colToString(c2)).append(r2 + 1).append('\"');
            if (this.style != 0) {
                w2.append(" s=\"").append(this.style).append('\"');
            }
            if (this.value != null && !(this.value instanceof Formula)) {
                w2.append(" t=\"").append(this.value instanceof String ? "str" : "n").append('\"');
            }
            w2.append(">");
            if (this.value instanceof Formula) {
                w2.append("<f>").append(((Formula)this.value).getExpression()).append("</f>");
            } else if (this.value != null) {
                w2.append("<v>");
                if (this.value instanceof CachedString) {
                    w2.append(((CachedString)this.value).getIndex());
                } else if (this.value instanceof Integer) {
                    w2.append((Integer)this.value);
                } else if (this.value instanceof Long) {
                    w2.append((Long)this.value);
                } else if (this.value instanceof Double) {
                    w2.append((Double)this.value);
                } else {
                    w2.append(this.value.toString());
                }
                w2.append("</v>");
            }
            w2.append("</c>");
        }
    }

    void setValue(Workbook wb, Object v2) {
        if (v2 instanceof String) {
            this.value = v2;
        } else if (v2 == null || v2 instanceof Number) {
            this.value = v2;
        } else if (v2 instanceof Date) {
            this.value = TimestampUtil.convertDate((Date)v2);
        } else if (v2 instanceof LocalDateTime) {
            this.value = TimestampUtil.convertDate(Date.from(((LocalDateTime)v2).atZone(ZoneId.systemDefault()).toInstant()));
        } else if (v2 instanceof LocalDate) {
            this.value = TimestampUtil.convertDate((LocalDate)v2);
        } else if (v2 instanceof ZonedDateTime) {
            this.value = TimestampUtil.convertZonedDateTime((ZonedDateTime)v2);
        } else {
            throw new IllegalArgumentException("No supported cell type for " + v2.getClass());
        }
    }

    Object getValue() {
        Object result = this.value instanceof CachedString ? ((CachedString)this.value).getString() : this.value;
        return result;
    }

    void setFormula(String expression) {
        this.value = new Formula(expression);
    }

    int getStyle() {
        return this.style;
    }

    void setStyle(int style) {
        this.style = style;
    }
}

