/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.ListDataValidation;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Worksheet;

public class Range {
    private final Worksheet worksheet;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;

    Range(Worksheet worksheet, int top, int left, int bottom, int right) {
        this.worksheet = Objects.requireNonNull(worksheet);
        if (top < 0 || top >= 0x100000 || bottom < 0 || bottom >= 0x100000) {
            throw new IllegalArgumentException();
        }
        if (left < 0 || left >= 16384 || right < 0 || right >= 16384) {
            throw new IllegalArgumentException();
        }
        this.top = top <= bottom ? top : bottom;
        this.left = left <= right ? left : right;
        this.bottom = bottom >= top ? bottom : top;
        this.right = right >= left ? right : left;
    }

    public Worksheet getWorksheet() {
        return this.worksheet;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.worksheet, this.top, this.left, this.bottom, this.right);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Range other = (Range)obj;
            result = Objects.equals(this.worksheet, other.worksheet) && Objects.equals(this.top, other.top) && Objects.equals(this.left, other.left) && Objects.equals(this.bottom, other.bottom) && Objects.equals(this.right, other.right);
        } else {
            result = false;
        }
        return result;
    }

    public static String colToString(int c2) {
        StringBuilder sb = new StringBuilder();
        while (c2 >= 0) {
            sb.append((char)(65 + c2 % 26));
            c2 = c2 / 26 - 1;
        }
        return sb.reverse().toString();
    }

    public String toString() {
        return Range.colToString(this.left) + Integer.toString(this.top + 1) + ':' + Range.colToString(this.right) + Integer.toString(this.bottom + 1);
    }

    public StyleSetter style() {
        return new StyleSetter(this);
    }

    public void merge() {
        this.worksheet.merge(this);
    }

    public boolean contains(int r2, int c2) {
        return r2 >= this.top && r2 <= this.bottom && c2 >= this.left && c2 <= this.right;
    }

    void shadeAlternateRows(Fill fill) {
        this.worksheet.shadeAlternateRows(this, fill);
    }

    public ListDataValidation validateWithList(Range listRange) {
        ListDataValidation listDataValidation = new ListDataValidation(this, listRange);
        this.worksheet.addValidation(listDataValidation);
        return listDataValidation;
    }

    Set<Integer> getStyles() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int r2 = this.top; r2 <= this.bottom; ++r2) {
            for (int c2 = this.left; c2 <= this.right; ++c2) {
                result.add(this.getWorksheet().cell(r2, c2).getStyle());
            }
        }
        return result;
    }

    void applyStyle(Map<Integer, Integer> styles) {
        for (int r2 = this.top; r2 <= this.bottom; ++r2) {
            for (int c2 = this.left; c2 <= this.right; ++c2) {
                Cell cell = this.getWorksheet().cell(r2, c2);
                cell.setStyle(styles.get(cell.getStyle()));
            }
        }
    }
}

