/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.Style;
import org.dhatim.fastexcel.ThrowingConsumer;
import org.dhatim.fastexcel.Writer;

final class StyleCache {
    private final ConcurrentMap<String, Integer> valueFormattings = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<Font, Integer> fonts = new ConcurrentHashMap<Font, Integer>();
    private final ConcurrentMap<Fill, Integer> fills = new ConcurrentHashMap<Fill, Integer>();
    private final ConcurrentMap<Border, Integer> borders = new ConcurrentHashMap<Border, Integer>();
    private final ConcurrentMap<Style, Integer> styles = new ConcurrentHashMap<Style, Integer>();
    private final ConcurrentMap<Fill, Integer> dxfs = new ConcurrentHashMap<Fill, Integer>();

    StyleCache() {
        this.mergeAndCacheStyle(0, null, Font.DEFAULT, Fill.NONE, Border.NONE, null);
        this.cacheFill(Fill.GRAY125);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> int cacheStuff(ConcurrentMap<T, Integer> cache, T t2, Function<T, Integer> indexFunction) {
        Integer index = (Integer)cache.get(t2);
        if (index == null) {
            ConcurrentMap<T, Integer> concurrentMap = cache;
            synchronized (concurrentMap) {
                index = cache.computeIfAbsent(t2, indexFunction);
            }
        }
        return index;
    }

    private static <T> int cacheStuff(ConcurrentMap<T, Integer> cache, T t2) {
        return StyleCache.cacheStuff(cache, t2, k2 -> cache.size());
    }

    int cacheValueFormatting(String s2) {
        if (s2 == null) {
            return 0;
        }
        return StyleCache.cacheStuff(this.valueFormattings, s2, k2 -> this.valueFormattings.size() + 165);
    }

    int cacheFont(Font f2) {
        return StyleCache.cacheStuff(this.fonts, f2);
    }

    int cacheFill(Fill f2) {
        return StyleCache.cacheStuff(this.fills, f2);
    }

    int cacheBorder(Border b2) {
        return StyleCache.cacheStuff(this.borders, b2);
    }

    int cacheDxf(Fill f2) {
        return StyleCache.cacheStuff(this.dxfs, f2);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment) {
        Style original = this.styles.entrySet().stream().filter(e2 -> ((Integer)e2.getValue()).equals(currentStyle)).map(Map.Entry::getKey).findFirst().orElse(null);
        Style s2 = new Style(original, this.cacheValueFormatting(numberingFormat), this.cacheFont(font), this.cacheFill(fill), this.cacheBorder(border), alignment);
        return StyleCache.cacheStuff(this.styles, s2);
    }

    private static <T> void writeCache(Writer w2, Map<T, Integer> cache, String name, ThrowingConsumer<Map.Entry<T, Integer>> consumer) throws IOException {
        w2.append('<').append(name).append(" count=\"").append(cache.size()).append("\">");
        ArrayList<Map.Entry<T, Integer>> entries = new ArrayList<Map.Entry<T, Integer>>(cache.entrySet());
        entries.sort((e1, e2) -> Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue()));
        for (Map.Entry entry : entries) {
            consumer.accept(entry);
        }
        w2.append("</").append(name).append('>');
    }

    void write(Writer w2) throws IOException {
        w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        StyleCache.writeCache(w2, this.valueFormattings, "numFmts", e2 -> w2.append("<numFmt numFmtId=\"").append((Integer)e2.getValue()).append("\" formatCode=\"").append((String)e2.getKey()).append("\"/>"));
        StyleCache.writeCache(w2, this.fonts, "fonts", e2 -> ((Font)e2.getKey()).write(w2));
        StyleCache.writeCache(w2, this.fills, "fills", e2 -> ((Fill)e2.getKey()).write(w2));
        StyleCache.writeCache(w2, this.borders, "borders", e2 -> ((Border)e2.getKey()).write(w2));
        w2.append("<cellStyleXfs count=\"1\"><xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\"/></cellStyleXfs>");
        StyleCache.writeCache(w2, this.styles, "cellXfs", e2 -> ((Style)e2.getKey()).write(w2));
        StyleCache.writeCache(w2, this.dxfs, "dxfs", e2 -> {
            w2.append("<dxf>");
            ((Fill)e2.getKey()).write(w2);
            w2.append("</dxf>");
        });
        w2.append("</styleSheet>");
    }
}

