/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.AlternateShading;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.DataValidation;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

public class Worksheet {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    public static final int MAX_COL_WIDTH = 255;
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final List<DataValidation> dataValidations = new ArrayList<DataValidation>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private final Set<Integer> hiddenRows = new HashSet<Integer>();
    private final Map<Integer, Double> colWidths = new HashMap<Integer, Double>();
    private boolean finished;
    private boolean dataWrited = false;
    private Integer rowSize = 0;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r2, int c2) {
        if (r2 < 0 || r2 >= 0x100000 || c2 < 0 || c2 >= 16384) {
            throw new IllegalArgumentException();
        }
        while (r2 >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r2);
        if (row == null) {
            int columns = Math.max(c2 + 1, r2 > 0 && this.rows.get(r2 - 1) != null ? this.rows.get(r2 - 1).length : c2 + 1);
            row = new Cell[columns];
            this.rows.set(r2, row);
        } else if (c2 >= row.length) {
            int columns = Math.max(c2 + 1, r2 > 0 && this.rows.get(r2 - 1) != null ? this.rows.get(r2 - 1).length : c2 + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r2, row);
        }
        if (row[c2] == null) {
            row[c2] = new Cell();
        }
        return row[c2];
    }

    void merge(Range range) {
        this.mergedRanges.add(range);
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheAlternateShadingFillColor(fill)));
    }

    void addValidation(DataValidation validation) {
        this.dataValidations.add(validation);
    }

    public void hideRow(int row) {
        this.hiddenRows.add(row);
    }

    public void showRow(int row) {
        this.hiddenRows.remove(row);
    }

    public void width(int c2, double width) {
        if (width > 255.0) {
            throw new IllegalArgumentException();
        }
        this.colWidths.put(c2, width);
    }

    public void value(int r2, int c2, Object value) {
        this.cell(r2, c2).setValue(this.workbook, value);
    }

    public Object value(int r2, int c2) {
        Cell[] row = r2 < this.rows.size() ? this.rows.get(r2) : null;
        Cell cell = row == null || c2 >= row.length ? null : row[c2];
        return cell == null ? null : cell.getValue();
    }

    public void formula(int r2, int c2, String expression) {
        this.cell(r2, c2).setFormula(expression);
    }

    public StyleSetter style(int r2, int c2) {
        return new Range(this, r2, c2, r2, c2).style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private boolean isCellInMergedRanges(int r2, int c2) {
        return this.mergedRanges.stream().filter(range -> range.contains(r2, c2)).findAny().isPresent();
    }

    private void writeCols(Writer w2, int nbCols) throws IOException {
        boolean started = false;
        for (int c2 = 0; c2 < nbCols; ++c2) {
            double maxWidth = 0.0;
            boolean bestFit = true;
            if (this.colWidths.containsKey(c2)) {
                bestFit = false;
                maxWidth = this.colWidths.get(c2);
            } else {
                for (int r2 = 0; r2 < this.rows.size(); ++r2) {
                    Object o2;
                    Object object = o2 = this.hiddenRows.contains(r2) || this.isCellInMergedRanges(r2, c2) ? null : this.value(r2, c2);
                    if (o2 == null || o2 instanceof Formula) continue;
                    int length = o2.toString().length();
                    maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
                }
            }
            if (!(maxWidth > 0.0)) continue;
            if (!started) {
                w2.append("<cols>");
                started = true;
            }
            w2.append("<col min=\"").append(c2 + 1).append("\" max=\"").append(c2 + 1).append("\" width=\"").append(Math.min(255.0, maxWidth)).append("\" customWidth=\"true\" bestFit=\"").append(String.valueOf(bestFit)).append("\"/>");
        }
        if (started) {
            w2.append("</cols>");
        }
    }

    public void flush() throws IOException {
        Writer w2 = this.workbook.getWriter();
        if (!this.dataWrited) {
            this.dataWrited = true;
            int index = this.workbook.getIndex(this);
            this.workbook.openFile("xl/worksheets/sheet" + Integer.toString(index) + ".xml");
            w2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(r2 -> r2 != null).map(r2 -> ((Cell[])r2).length).reduce(0, Math::max);
            if (nbCols > 0) {
                this.writeCols(w2, nbCols);
            }
            w2.append("<sheetData>");
        }
        for (int r3 = 0; r3 < this.rows.size(); ++r3) {
            Cell[] row = this.rows.get(r3);
            if (row != null) {
                Worksheet.writeRow(w2, this.rowSize, this.hiddenRows.contains(r3), row);
            }
            Worksheet worksheet = this;
            Integer.valueOf(worksheet.rowSize + 1);
            worksheet.rowSize = worksheet.rowSize;
        }
        this.rows.clear();
        w2.flush();
    }

    public void finish() throws IOException {
        Writer w2 = this.workbook.getWriter();
        w2.append("</sheetData>");
        if (!this.mergedRanges.isEmpty()) {
            w2.append("<mergeCells>");
            for (Range r2 : this.mergedRanges) {
                w2.append("<mergeCell ref=\"").append(r2.toString()).append("\"/>");
            }
            w2.append("</mergeCells>");
        }
        if (!this.dataValidations.isEmpty()) {
            w2.append("<dataValidations count=\"").append(this.dataValidations.size()).append("\">");
            for (DataValidation v2 : this.dataValidations) {
                v2.write(w2);
            }
            w2.append("</dataValidations>");
        }
        for (AlternateShading a2 : this.alternateShadingRanges) {
            a2.write(w2);
        }
        w2.append("<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/></worksheet>");
        w2.flush();
        this.rows.clear();
        this.finished = true;
    }

    private static void writeRow(Writer w2, int r2, boolean isHidden, Cell ... row) throws IOException {
        w2.append("<row r=\"").append(r2 + 1);
        if (isHidden) {
            w2.append("\" hidden=\"").append(String.valueOf(isHidden));
        }
        w2.append("\">");
        for (int c2 = 0; c2 < row.length; ++c2) {
            if (row[c2] == null) continue;
            row[c2].write(w2, r2, c2);
        }
        w2.append("</row>");
    }
}

