/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.sql2o.logging.LocalLoggerFactory;
import org.sql2o.logging.Logger;

public class JndiDataSource {
    private static final Logger logger = LocalLoggerFactory.getLogger(JndiDataSource.class);

    static DataSource getJndiDatasource(String jndiLookup) {
        InitialContext ctx = null;
        DataSource datasource = null;
        try {
            ctx = new InitialContext();
            datasource = (DataSource)ctx.lookup(jndiLookup);
        }
        catch (NamingException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable e3) {
                    logger.warn("error closing context", e3);
                }
            }
        }
        return datasource;
    }
}

