/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks.parameterparsing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sql2o.quirks.parameterparsing.impl.CharParser;

public class ParameterParser
implements CharParser {
    private final Map<String, List<Integer>> parameterMap;
    int paramIdx = 1;

    public ParameterParser(Map<String, List<Integer>> parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    public boolean canParse(char c2, String sql, int idx) {
        return sql.length() > idx + 1 && c2 == ':' && Character.isJavaIdentifierStart(sql.charAt(idx + 1)) && sql.charAt(idx - 1) != ':';
    }

    @Override
    public int parse(char c2, int idx, StringBuilder parsedSql, String sql, int length) {
        int startIdx = idx++;
        while (idx + 1 < length && Character.isJavaIdentifierPart(sql.charAt(idx + 1))) {
            ++idx;
        }
        String name = sql.substring(startIdx + 1, idx + 1);
        List<Integer> indices = this.parameterMap.get(name);
        if (indices == null) {
            indices = new ArrayList<Integer>();
            this.parameterMap.put(name, indices);
        }
        indices.add(this.paramIdx++);
        parsedSql.append("?");
        return idx;
    }
}

