/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sql2o.reflection.FieldGetterFactory;
import org.sql2o.reflection.FieldSetterFactory;
import org.sql2o.reflection.Getter;
import org.sql2o.reflection.MethodGetterFactory;
import org.sql2o.reflection.MethodSetterFactory;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.ObjectConstructorFactory;
import org.sql2o.reflection.ReflectionFieldGetterFactory;
import org.sql2o.reflection.ReflectionFieldSetterFactory;
import org.sql2o.reflection.ReflectionMethodGetterFactory;
import org.sql2o.reflection.ReflectionMethodSetterFactory;
import org.sql2o.reflection.ReflectionObjectConstructorFactory;
import org.sql2o.reflection.Setter;

public class FactoryFacade {
    private static final FactoryFacade instance;
    private final FieldGetterFactory fieldGetterFactory;
    private final MethodGetterFactory methodGetterFactory;
    private final FieldSetterFactory fieldSetterFactory;
    private final MethodSetterFactory methodSetterFactory;
    private final ObjectConstructorFactory objectConstructorFactory;

    public FactoryFacade(FieldGetterFactory fieldGetterFactory, MethodGetterFactory methodGetterFactory, FieldSetterFactory fieldSetterFactory, MethodSetterFactory methodSetterFactory, ObjectConstructorFactory objectConstructorFactory) {
        this.fieldGetterFactory = fieldGetterFactory;
        this.methodGetterFactory = methodGetterFactory;
        this.fieldSetterFactory = fieldSetterFactory;
        this.methodSetterFactory = methodSetterFactory;
        this.objectConstructorFactory = objectConstructorFactory;
    }

    public static FactoryFacade getInstance() {
        return instance;
    }

    public Getter newGetter(Field field) {
        return this.fieldGetterFactory.newGetter(field);
    }

    public Getter newGetter(Method method) {
        return this.methodGetterFactory.newGetter(method);
    }

    public Setter newSetter(Field field) {
        return this.fieldSetterFactory.newSetter(field);
    }

    public Setter newSetter(Method method) {
        return this.methodSetterFactory.newSetter(method);
    }

    public ObjectConstructor newConstructor(Class<?> cls) {
        return this.objectConstructorFactory.newConstructor(cls);
    }

    static {
        FieldSetterFactory f2;
        FieldGetterFactory fg;
        ObjectConstructorFactory o2;
        MethodGetterFactory mg;
        MethodSetterFactory m2;
        try {
            m2 = (MethodSetterFactory)Class.forName("org.sql2o.reflection.MethodAccessorsGenerator").newInstance();
            mg = (MethodGetterFactory)((Object)m2);
            o2 = (ObjectConstructorFactory)((Object)m2);
        }
        catch (Throwable ex) {
            mg = new ReflectionMethodGetterFactory();
            m2 = new ReflectionMethodSetterFactory();
            o2 = null;
        }
        try {
            Class<?> clsg = Class.forName("org.sql2o.reflection.UnsafeFieldGetterFactory");
            fg = (FieldGetterFactory)clsg.newInstance();
            Class<?> cls = Class.forName("org.sql2o.reflection.UnsafeFieldSetterFactory");
            f2 = (FieldSetterFactory)cls.newInstance();
            if (o2 == null) {
                o2 = (ObjectConstructorFactory)((Object)f2);
            }
        }
        catch (Throwable ex) {
            fg = new ReflectionFieldGetterFactory();
            f2 = new ReflectionFieldSetterFactory();
            o2 = new ReflectionObjectConstructorFactory();
        }
        instance = new FactoryFacade(fg, mg, f2, m2, o2);
    }
}

