/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sql2o.Sql2oException;
import org.sql2o.reflection.Getter;
import org.sql2o.reflection.MethodGetterFactory;
import org.sql2o.reflection.MethodSetterFactory;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.ObjectConstructorFactory;
import org.sql2o.reflection.Setter;
import org.sql2o.reflection.UnsafeFieldSetterFactory;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.MethodAccessor;

public class MethodAccessorsGenerator
implements MethodGetterFactory,
MethodSetterFactory,
ObjectConstructorFactory {
    private static final ThreadLocal<Object> generatorObjectHolder;
    private static final MethodAccessor generateMethod;
    private static final MethodAccessor generateConstructor;
    private static final MethodAccessor generateSerializationConstructor;
    private static final MethodAccessor newFieldAccessor;

    public static FieldAccessor newFieldAccessor(Field field, boolean overrideFinalCheck) {
        try {
            return (FieldAccessor)newFieldAccessor.invoke(null, new Object[]{field, overrideFinalCheck});
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static MethodAccessor newMethodAccessor(Method bar) {
        try {
            return MethodAccessorsGenerator.newMethodAccessor(generatorObjectHolder.get(), bar);
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static MethodAccessor newMethodAccessor(Object generatorObject, Method bar) throws InvocationTargetException {
        return (MethodAccessor)generateMethod.invoke(generatorObject, new Object[]{bar.getDeclaringClass(), bar.getName(), bar.getParameterTypes(), bar.getReturnType(), bar.getExceptionTypes(), bar.getModifiers()});
    }

    public static ConstructorAccessor newConstructorAccessor(Constructor<?> bar) {
        try {
            return MethodAccessorsGenerator.newConstructorAccessor(generatorObjectHolder.get(), bar);
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static ConstructorAccessor newConstructorAccessor(Object generatorObject, Constructor<?> bar) throws InvocationTargetException {
        return (ConstructorAccessor)generateConstructor.invoke(generatorObject, new Object[]{bar.getDeclaringClass(), bar.getParameterTypes(), bar.getExceptionTypes(), bar.getModifiers()});
    }

    public static ConstructorAccessor newConstructorAccessor(Constructor<?> bar, Class<?> targetClass) {
        try {
            return (ConstructorAccessor)generateSerializationConstructor.invoke(generatorObjectHolder.get(), new Object[]{targetClass, bar.getParameterTypes(), bar.getExceptionTypes(), bar.getModifiers(), bar.getDeclaringClass()});
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Getter newGetter(final Method method) {
        final Class<?> type = method.getReturnType();
        final MethodAccessor methodAccessor = MethodAccessorsGenerator.newMethodAccessor(method);
        return new Getter(){

            @Override
            public Object getProperty(Object obj) {
                try {
                    return methodAccessor.invoke(obj, null);
                }
                catch (InvocationTargetException e2) {
                    throw new Sql2oException("error while calling getter method with name " + method.getName() + " on class " + obj.getClass().toString(), e2);
                }
            }

            @Override
            public Class getType() {
                return type;
            }
        };
    }

    @Override
    public Setter newSetter(final Method method) {
        final Class<?> type = method.getParameterTypes()[0];
        final MethodAccessor methodAccessor = MethodAccessorsGenerator.newMethodAccessor(method);
        return new Setter(){

            @Override
            public void setProperty(Object obj, Object value) {
                if (value == null && type.isPrimitive()) {
                    return;
                }
                try {
                    methodAccessor.invoke(obj, new Object[]{value});
                }
                catch (InvocationTargetException e2) {
                    throw new Sql2oException("error while calling setter method with name " + method.getName() + " on class " + obj.getClass().toString(), e2);
                }
            }

            @Override
            public Class getType() {
                return type;
            }
        };
    }

    @Override
    public ObjectConstructor newConstructor(final Class<?> cls) {
        Class<?> cls0 = cls;
        while (cls != Object.class) {
            try {
                Constructor<?> ctor = cls0.getDeclaredConstructor(new Class[0]);
                final ConstructorAccessor constructorAccessor = cls0 == cls ? MethodAccessorsGenerator.newConstructorAccessor(ctor) : MethodAccessorsGenerator.newConstructorAccessor(ctor, cls);
                return new ObjectConstructor(){

                    @Override
                    public Object newInstance() {
                        try {
                            return constructorAccessor.newInstance(null);
                        }
                        catch (InstantiationException | InvocationTargetException e2) {
                            throw new Sql2oException("Could not create a new instance of class " + cls, e2);
                        }
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
                cls0 = cls0.getSuperclass();
            }
        }
        return UnsafeFieldSetterFactory.getConstructor(cls);
    }

    static {
        try {
            Class<?> aClass = Class.forName("sun.reflect.MethodAccessorGenerator");
            Constructor<?>[] declaredConstructors = aClass.getDeclaredConstructors();
            Constructor<?> declaredConstructor = declaredConstructors[0];
            declaredConstructor.setAccessible(true);
            Object generatorObject = declaredConstructor.newInstance(new Object[0]);
            Method bar = aClass.getMethod("generateMethod", Class.class, String.class, Class[].class, Class.class, Class[].class, Integer.TYPE);
            bar.setAccessible(true);
            generateMethod = (MethodAccessor)bar.invoke(generatorObject, bar.getDeclaringClass(), bar.getName(), bar.getParameterTypes(), bar.getReturnType(), bar.getExceptionTypes(), bar.getModifiers());
            bar = aClass.getMethod("generateConstructor", Class.class, Class[].class, Class[].class, Integer.TYPE);
            generateConstructor = MethodAccessorsGenerator.newMethodAccessor(generatorObject, bar);
            bar = aClass.getMethod("generateSerializationConstructor", Class.class, Class[].class, Class[].class, Integer.TYPE, Class.class);
            final ConstructorAccessor goc = MethodAccessorsGenerator.newConstructorAccessor(generatorObject, declaredConstructor);
            generatorObjectHolder = new ThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    try {
                        return goc.newInstance(null);
                    }
                    catch (Throwable e2) {
                        throw new RuntimeException(e2);
                    }
                }
            };
            generateSerializationConstructor = MethodAccessorsGenerator.newMethodAccessor(generatorObject, bar);
            aClass = Class.forName("sun.reflect.UnsafeFieldAccessorFactory");
            bar = aClass.getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            newFieldAccessor = MethodAccessorsGenerator.newMethodAccessor(generatorObject, bar);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

