/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import org.sql2o.Sql2oException;
import org.sql2o.converters.Convert;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.quirks.Quirks;
import org.sql2o.reflection.Getter;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.PojoMetadata;
import org.sql2o.reflection.Setter;

public class Pojo {
    private PojoMetadata metadata;
    private boolean caseSensitive;
    private Object object;

    public Pojo(PojoMetadata metadata, boolean caseSensitive, Object object) {
        this.caseSensitive = caseSensitive;
        this.metadata = metadata;
        this.object = object;
    }

    public Pojo(PojoMetadata metadata, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.metadata = metadata;
        ObjectConstructor objectConstructor = metadata.getObjectConstructor();
        this.object = objectConstructor.newInstance();
    }

    public Object getProperty(String propertyPath, Quirks quirks) {
        Converter converter;
        int index = propertyPath.indexOf(46);
        if (index > 0) {
            String substring = propertyPath.substring(0, index);
            Getter getter = this.metadata.getPropertyGetter(substring);
            String newPath = propertyPath.substring(index + 1);
            Object subValue = this.metadata.getValueOfProperty(substring, this.object);
            if (subValue == null) {
                try {
                    subValue = getter.getType().newInstance();
                }
                catch (InstantiationException e2) {
                    throw new Sql2oException("Could not instantiate a new instance of class " + getter.getType().toString(), e2);
                }
                catch (IllegalAccessException e3) {
                    throw new Sql2oException("Could not instantiate a new instance of class " + getter.getType().toString(), e3);
                }
                return getter.getProperty(this.object);
            }
            PojoMetadata subMetadata = new PojoMetadata(getter.getType(), this.caseSensitive, this.metadata.isAutoDeriveColumnNames(), this.metadata.getColumnMappings(), this.metadata.throwOnMappingFailure);
            Pojo subPojo = new Pojo(subMetadata, this.caseSensitive, subValue);
            return subPojo.getProperty(newPath, quirks);
        }
        Getter getter = this.metadata.getPropertyGetter(propertyPath);
        try {
            converter = Convert.throwIfNull(getter.getType(), quirks.converterOf(getter.getType()));
        }
        catch (ConverterException e4) {
            throw new Sql2oException("Cannot convert column " + propertyPath + " to type " + getter.getType(), e4);
        }
        try {
            return converter.convert(getter.getProperty(this.object));
        }
        catch (ConverterException e5) {
            throw new Sql2oException("Error trying to convert column " + propertyPath + " to type " + getter.getType(), e5);
        }
    }

    public void setProperty(String propertyPath, Object value, Quirks quirks) {
        int index = propertyPath.indexOf(46);
        if (index > 0) {
            String substring = propertyPath.substring(0, index);
            Setter setter = this.metadata.getPropertySetter(substring);
            String newPath = propertyPath.substring(index + 1);
            Object subValue = this.metadata.getValueOfProperty(substring, this.object);
            if (subValue == null) {
                try {
                    subValue = setter.getType().newInstance();
                }
                catch (InstantiationException e2) {
                    throw new Sql2oException("Could not instantiate a new instance of class " + setter.getType().toString(), e2);
                }
                catch (IllegalAccessException e3) {
                    throw new Sql2oException("Could not instantiate a new instance of class " + setter.getType().toString(), e3);
                }
                setter.setProperty(this.object, subValue);
            }
            PojoMetadata subMetadata = new PojoMetadata(setter.getType(), this.caseSensitive, this.metadata.isAutoDeriveColumnNames(), this.metadata.getColumnMappings(), this.metadata.throwOnMappingFailure);
            Pojo subPojo = new Pojo(subMetadata, this.caseSensitive, subValue);
            subPojo.setProperty(newPath, value, quirks);
        } else {
            Converter converter;
            Setter setter = this.metadata.getPropertySetter(propertyPath);
            try {
                converter = Convert.throwIfNull(setter.getType(), quirks.converterOf(setter.getType()));
            }
            catch (ConverterException e4) {
                throw new Sql2oException("Cannot convert column " + propertyPath + " to type " + setter.getType(), e4);
            }
            try {
                setter.setProperty(this.object, converter.convert(value));
            }
            catch (ConverterException e5) {
                throw new Sql2oException("Error trying to convert column " + propertyPath + " to type " + setter.getType(), e5);
            }
        }
    }

    public Object getObject() {
        return this.object;
    }
}

