/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.cache;

import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.annotation.Column;
import com.definesys.mpaas.query.annotation.ColumnType;
import com.definesys.mpaas.query.annotation.RowID;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.annotation.SystemColumn;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.annotation.Tag;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PojoField {
    private Field field;
    private Boolean isRowId;
    private String sqlColumnName;
    private SystemColumnType systemColumnType;
    private Method getter;
    private Method setter;
    private String displayName;
    private ColumnType columnType;
    private Style style;
    private JsonDeserialize deserialize;

    public PojoField(Field f2, Method getter, Method setter) {
        this.field = f2;
        this.getter = getter;
        this.setter = setter;
        this.init();
    }

    private void init() {
        String s2;
        this.isRowId = this.field.getAnnotation(RowID.class) != null;
        if (this.field.getAnnotation(Column.class) != null && !MpaasUtil.strEmpty(s2 = this.field.getAnnotation(Column.class).value())) {
            this.sqlColumnName = s2;
        }
        if (this.field.getAnnotation(SystemColumn.class) != null) {
            this.systemColumnType = this.field.getAnnotation(SystemColumn.class).value();
        }
        this.displayName = this.field.getName();
        this.columnType = ColumnType.DB;
        Column c2 = this.field.getAnnotation(Column.class);
        this.style = this.field.getAnnotation(Style.class);
        this.deserialize = this.field.getAnnotation(JsonDeserialize.class);
        if (c2 != null) {
            if (c2.display() != null && c2.display().trim().length() > 0) {
                this.displayName = c2.display();
            }
            if (c2.type() != null) {
                this.columnType = c2.type();
            }
        }
        if (this.style != null && !MpaasUtil.strEmpty(this.style.displayName())) {
            this.displayName = this.style.displayName();
        }
    }

    public Object getTagValue() {
        Tag tag = this.field.getAnnotation(Tag.class);
        return tag == null ? null : tag.value();
    }

    public Object getValue(Object pojo) {
        if (this.getter != null) {
            try {
                return this.getter.invoke(pojo, new Object[0]);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InvocationTargetException e3) {
                e3.printStackTrace();
            }
        }
        return null;
    }

    public Object getFormatValue(Object pojo) {
        if (pojo == null) {
            return null;
        }
        Object value = this.getValue(pojo);
        String format = "yyyy/MM/dd";
        Object result = value;
        if (value instanceof Date) {
            if (this.style != null && !MpaasUtil.strEmpty(this.style.format())) {
                format = this.style.format();
            } else if (this.deserialize != null && "MpaasDateTimeDeserializer".equals(this.deserialize.using().getSimpleName())) {
                format = "yyyy/MM/dd HH:mm:ss";
            }
            result = new SimpleDateFormat(format).format((Date)value);
        }
        return result;
    }

    public void setValue(Object pojo, Object value) {
        if (this.setter != null) {
            try {
                this.setter.invoke(pojo, value);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InvocationTargetException e3) {
                e3.printStackTrace();
            }
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Boolean isKeyField() {
        return this.isRowId;
    }

    public String getSqlColumnName(Boolean upper2Uderline) {
        if (this.sqlColumnName != null) {
            return this.sqlColumnName;
        }
        return upper2Uderline != false ? MpaasQueryUtil.upper2Underline(this.field.getName()) : this.field.getName();
    }

    public void setSqlColumnName(String sqlColumnName) {
        this.sqlColumnName = sqlColumnName;
    }

    public SystemColumnType getSystemColumnType() {
        return this.systemColumnType;
    }

    public void setSystemColumnType(SystemColumnType systemColumnType) {
        this.systemColumnType = systemColumnType;
    }

    public Method getter() {
        return this.getter;
    }

    public Method setter() {
        return this.setter;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean isRowId() {
        return this.isRowId;
    }

    public Boolean isDBColumn() {
        return this.columnType == ColumnType.DB;
    }

    public Boolean isQueryColumn() {
        return this.columnType == ColumnType.DB || this.columnType == ColumnType.CALCULATE;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }
}

