/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.cache;

import com.definesys.mpaas.cache.PojoField;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.Clause;
import com.definesys.mpaas.query.annotation.SQL;
import com.definesys.mpaas.query.annotation.SQLQuery;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.annotation.Table;
import com.definesys.mpaas.query.session.MpaasSession;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PojoMeta {
    private String tableName;
    private Boolean upper2Underline = true;
    private List<PojoField> pojoFields = new ArrayList<PojoField>();
    private Map<String, SQL> sqlQuerys;

    public PojoMeta(Class clazz) {
        this.init(clazz);
    }

    public void init(Class clazz) {
        SQLQuery sqlQuery;
        Table t2;
        Class tmp;
        Hashtable<String, Method> getter = new Hashtable<String, Method>();
        Hashtable<String, Method> setter = new Hashtable<String, Method>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (tmp = clazz; tmp != null && !tmp.getClass().getName().equals(Object.class.getName()); tmp = tmp.getSuperclass()) {
            methods.addAll(Arrays.asList(tmp.getDeclaredMethods()));
        }
        for (Method m2 : methods) {
            if (m2.getName().startsWith("get") || m2.getName().startsWith("is")) {
                getter.put(m2.getName().toLowerCase(), m2);
                continue;
            }
            if (!m2.getName().startsWith("set")) continue;
            setter.put(m2.getName().toLowerCase(), m2);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (tmp = clazz; tmp != null && !tmp.getClass().getName().equals(Object.class.getName()); tmp = tmp.getSuperclass()) {
            fields.addAll(Arrays.asList(tmp.getDeclaredFields()));
        }
        Style style = clazz.getAnnotation(Style.class);
        if (style != null) {
            this.upper2Underline = style.Upper2Underline();
        }
        for (Field f2 : fields) {
            Method m1 = (Method)getter.get("get" + f2.getName().toLowerCase());
            if (m1 == null && f2.getType() == Boolean.class) {
                m1 = (Method)getter.get("is" + f2.getName().toLowerCase());
            }
            this.pojoFields.add(new PojoField(f2, m1, (Method)setter.get("set" + f2.getName().toLowerCase())));
        }
        this.tableName = clazz.getSimpleName();
        if (this.upper2Underline.booleanValue()) {
            this.tableName = MpaasQueryUtil.upper2Underline(this.tableName);
        }
        if ((t2 = clazz.getAnnotation(Table.class)) != null && t2.value() != null) {
            this.tableName = t2.value();
        }
        if ((sqlQuery = clazz.getAnnotation(SQLQuery.class)) != null) {
            SQL[] sqls;
            this.sqlQuerys = new HashMap<String, SQL>();
            for (SQL sql : sqls = sqlQuery.value()) {
                this.sqlQuerys.put(sql.view().toLowerCase(), sql);
            }
        }
    }

    public Object insertActionInit(Object pojo) {
        String user = MpaasSession.getCurrentUser();
        try {
            for (PojoField f2 : this.pojoFields) {
                Method setMethod;
                SystemColumnType st = f2.getSystemColumnType();
                if (st == null || (setMethod = f2.setter()) == null) continue;
                if (SystemColumnType.CREATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    continue;
                }
                if (SystemColumnType.CREATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    continue;
                }
                if (SystemColumnType.OBJECT_VERSION != st) continue;
                Class<?> types = setMethod.getParameterTypes()[0];
                if (types == Long.class) {
                    setMethod.invoke(pojo, 1L);
                    continue;
                }
                if (types == Integer.class) {
                    setMethod.invoke(pojo, 1);
                    continue;
                }
                if (types == Double.class) {
                    setMethod.invoke(pojo, new Double(1.0));
                    continue;
                }
                if (types == Float.class) {
                    setMethod.invoke(pojo, new Float(1.0f));
                    continue;
                }
                throw new MpaasRuntimeException("pojo " + pojo.getClass() + " object version type must be Long or Integer");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pojo;
    }

    public List<Clause> updateActionInit(Object pojo, String[] fields) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        List<PojoField> updateFields = this.pojoFields;
        if (fields != null && fields.length > 0) {
            updateFields = new ArrayList<PojoField>();
            for (String v2 : fields) {
                PojoField f2 = this.findPojoField(v2);
                if (f2 == null) {
                    throw new MpaasRuntimeException("field:" + v2 + " not found");
                }
                updateFields.add(f2);
            }
        }
        try {
            for (PojoField f3 : updateFields) {
                Method getMethod;
                if (f3.isKeyField().booleanValue() || !f3.isDBColumn().booleanValue()) continue;
                SystemColumnType st = f3.getSystemColumnType();
                String columnName = f3.getSqlColumnName(this.upper2Underline);
                if (st != null || (getMethod = f3.getter()) == null) continue;
                Object value = getMethod.invoke(pojo, new Object[0]);
                if (value == null) {
                    Clause c2 = new Clause(columnName, null);
                    c2.setTag(String.format("%s = null", columnName));
                    clauses.add(c2);
                    continue;
                }
                clauses.add(new Clause(columnName, value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        clauses.addAll(this.updateSystemField(pojo));
        return clauses;
    }

    private List<Clause> updateSystemField(Object pojo) {
        String user = MpaasSession.getCurrentUser();
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (PojoField f2 : this.pojoFields) {
            Method setMethod;
            SystemColumnType st = f2.getSystemColumnType();
            String columnName = f2.getSqlColumnName(this.upper2Underline);
            if (st == null || (setMethod = f2.setter()) == null) continue;
            try {
                if (SystemColumnType.LASTUPDATE_BY == st) {
                    setMethod.invoke(pojo, user);
                    clauses.add(new Clause(columnName, user));
                    continue;
                }
                if (SystemColumnType.LASTUPDATE_ON == st) {
                    setMethod.invoke(pojo, MpaasQueryUtil.currentDate());
                    clauses.add(new Clause(columnName, MpaasQueryUtil.currentDate()));
                    continue;
                }
                if (SystemColumnType.OBJECT_VERSION != st) continue;
                Clause c2 = new Clause(columnName, null);
                c2.setTag(String.format("%s = %s+1", columnName, columnName));
                clauses.add(c2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return clauses;
    }

    private String getterName(Field f2) {
        String name = f2.getName().toLowerCase();
        if (f2.getType() == Boolean.class) {
            return "is" + name.substring(0, 1) + name.substring(1);
        }
        return "get" + name.substring(0, 1) + name.substring(1);
    }

    private String setterName(Field f2) {
        String name = f2.getName().toLowerCase();
        return "set" + name.substring(0, 1) + name.substring(1);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getUpper2Underline() {
        return this.upper2Underline;
    }

    public void setUpper2Underline(Boolean upper2Underline) {
        this.upper2Underline = upper2Underline;
    }

    public List<PojoField> getPojoFields() {
        return this.pojoFields;
    }

    public List<PojoField> getDatabaseFields() {
        ArrayList<PojoField> fs = new ArrayList<PojoField>();
        for (PojoField f2 : this.pojoFields) {
            if (!f2.isDBColumn().booleanValue()) continue;
            fs.add(f2);
        }
        return fs;
    }

    public void setPojoFields(List<PojoField> pojoFields) {
        this.pojoFields = pojoFields;
    }

    public PojoField findPojoField(String name) {
        for (PojoField f2 : this.pojoFields) {
            if (f2.getSqlColumnName(this.upper2Underline).equalsIgnoreCase(name)) {
                return f2;
            }
            if (!f2.getField().getName().equalsIgnoreCase(name)) continue;
            return f2;
        }
        return null;
    }

    public String getFieldDBName(String name) {
        PojoField p2 = this.findPojoField(name);
        if (p2 == null) {
            throw new MpaasRuntimeException("can not find field " + name);
        }
        return p2.getSqlColumnName(this.upper2Underline);
    }

    public Map<String, SQL> getSqlQuerys() {
        return this.sqlQuerys;
    }
}

