/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mybatis;

import com.definesys.mpaas.cache.Cache;
import com.definesys.mpaas.cache.PojoField;
import com.definesys.mpaas.cache.PojoMeta;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.mybatis.QueryWrapper;
import com.definesys.mpaas.mybatis.mapper.SWordMybatisMapper;
import com.definesys.mpaas.query.db.DefaultDatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.util.TypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MybatisDatabaseAdapter
extends DefaultDatabaseAdapter {
    @Autowired
    private SWordMybatisMapper sWordMapper;
    @Autowired
    private SWordLogger logger;

    @Override
    public <T> List<T> executeQuery(QueryInfo queryInfo, String sql, List<Parameter> params, Class<T> result) {
        QueryWrapper wrapper = this.wrapper(sql, params);
        List<Map<String, Object>> rows = this.sWordMapper.query(wrapper);
        ArrayList<Object> _rows = new ArrayList<Object>();
        this.log("executeQuery", sql, params);
        try {
            PojoMeta meta = (PojoMeta)Cache.cache().get(result, null);
            for (Map<String, Object> row : rows) {
                Object r2 = null;
                if ("java.lang.Long".equals(result.getName())) {
                    for (String c2 : row.keySet()) {
                        r2 = Class.forName("java.lang.Long").getConstructor(Class.forName("java.lang.String")).newInstance(row.get(c2).toString());
                    }
                } else {
                    r2 = Class.forName(result.getName()).newInstance();
                    for (String c2 : row.keySet()) {
                        PojoField field = meta.findPojoField(c2);
                        if (field == null) continue;
                        field.setValue(r2, TypeUtil.convert(row.get(c2), field.getField().getType()));
                    }
                }
                _rows.add(r2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return _rows;
    }

    @Override
    public List<Map<String, Object>> executeQueryAsList(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeQueryAsList", sql, params);
        return this.sWordMapper.query(this.wrapper(sql, params));
    }

    @Override
    public int executeDelete(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeDelete", sql, params);
        this.evailValid(params);
        return this.sWordMapper.delete(this.wrapper(sql, params));
    }

    @Override
    public int executeUpdate(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeUpdate", sql, params);
        this.evailValid(params);
        return this.sWordMapper.update(this.wrapper(sql, params));
    }

    @Override
    public Object executeInsert(QueryInfo queryInfo, String sql, List<Parameter> params, String ... keyColumns) {
        this.log("executeInsert", sql, params);
        QueryWrapper wrapper = this.wrapper(sql, params);
        this.sWordMapper.insert(wrapper);
        return wrapper.getId();
    }

    private void evailValid(List<Parameter> params) {
        if (params == null || params.size() == 0) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
        boolean bok = true;
        for (Parameter p2 : params) {
            if (p2.getValue() == null) continue;
            bok = false;
            break;
        }
        if (bok) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
    }

    private QueryWrapper wrapper(String sql, List<Parameter> params) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setSql(sql);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (params != null) {
            for (Parameter p2 : params) {
                data.put(p2.getName(), p2.getValue());
            }
        }
        wrapper.setParams(data);
        return wrapper;
    }

    private void log(String action, String sql, List<Parameter> parameters) {
        this.logger.debug(action + " sql==>%s", sql);
        if (parameters != null) {
            this.logger.debug("params:", new Object[0]);
            for (Parameter p2 : parameters) {
                this.logger.debug("%s ==> %s", p2.getName(), p2.getValue());
            }
        }
    }
}

