/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query;

import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.MpaasQuery;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.DialectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MpaasQueryFactory {
    @Autowired
    private DialectFactory dialectFactory;
    @Autowired
    private DatabaseAdapterFactory databaseAdapterFactory;
    @Autowired
    private MpaasQueryConfig config;
    @Autowired
    private SWordLogger logger;

    @Autowired
    public MpaasQueryFactory(DialectFactory dialectFactory) {
        this.dialectFactory = dialectFactory;
    }

    public MpaasQuery buildQuery() {
        return this.buildQuery(null, null, null);
    }

    public MpaasQuery buildQuery(Object pojo) {
        return this.buildQuery(pojo, null, null);
    }

    public MpaasQuery buildQuery(Class clazz) {
        return this.buildQuery(null, clazz, null);
    }

    private MpaasQuery buildQuery(Object pojo, Class clazz, String view) {
        Dialect dialect = this.dialectFactory.buildDatabaseDialect();
        MpaasQuery mpaasQuery = new MpaasQuery(dialect, this.databaseAdapterFactory.buildDatabaseAdapter(), this.config, this.logger);
        mpaasQuery.pageSize(this.config.PAGE_SIZE);
        mpaasQuery.view(view);
        if (view != null) {
            mpaasQuery.viewQueryMode(true);
        }
        if (pojo != null) {
            mpaasQuery.bind(clazz);
        }
        if (clazz != null) {
            mpaasQuery.bind(clazz);
        }
        return mpaasQuery;
    }

    public MpaasQuery buildViewQuery() {
        return this.buildQuery(null, null, null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Object pojo) {
        return this.buildQuery(pojo, pojo.getClass(), null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Class clazz) {
        return this.buildQuery(null, clazz, null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(String view) {
        return this.buildQuery(null, null, view).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Object pojo, String view) {
        return this.buildQuery(pojo, pojo.getClass(), view).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Class clazz, String view) {
        return this.buildQuery(null, clazz, view).viewQueryMode(true);
    }
}

